package org.mule.datasense.api.metadataprovider;

import com.google.common.collect.ImmutableList;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ConfigFile;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.internal.xml.parser.XmlApplicationParser;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

import javax.xml.parsers.SAXParserFactory;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import static org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader.noValidationDocumentLoader;

public class MuleAppHelper {

  public static List<XmlNamespaceInfoProvider> discoverNamespaceInfoProviders(ServiceRegistry serviceRegistry,
                                                                              List<ClassLoader> pluginsClassLoaders) {
    ImmutableList.Builder<XmlNamespaceInfoProvider> namespaceInfoProvidersBuilder = ImmutableList.builder();
    namespaceInfoProvidersBuilder
        .addAll(serviceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, Thread.currentThread().getContextClassLoader()));
    pluginsClassLoaders
        .forEach(pluginClassLoader -> namespaceInfoProvidersBuilder
            .addAll(serviceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, pluginClassLoader)));
    return namespaceInfoProvidersBuilder.build();
  }

  public static Optional<ConfigLine> loadConfigLines(InputStream inputStream) {
    ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    Document document =
        noValidationDocumentLoader().loadDocument(SAXParserFactory::newInstance, "config", inputStream, new DefaultHandler());
    XmlApplicationParser xmlApplicationParser =
        new XmlApplicationParser(discoverNamespaceInfoProviders(serviceRegistry, Collections.emptyList()));
    return xmlApplicationParser.parse(document.getDocumentElement());
  }

  public static org.mule.runtime.config.internal.model.ApplicationModel loadApplicationModel(ConfigLine configLine,
                                                                                             String fileName)
      throws Exception {
    ArtifactConfig artifactConfig = new ArtifactConfig.Builder()
        .addConfigFile(new ConfigFile(fileName, Collections.singletonList(configLine))).build();
    return loadApplicationModel(artifactConfig, fileName, Collections.emptySet(),
                                Optional.of(new ComponentBuildingDefinitionRegistry()),
                                false, s -> {
                                  throw new UnsupportedOperationException();
                                });
  }

  public static org.mule.runtime.config.internal.model.ApplicationModel loadApplicationModel(
                                                                                             ArtifactConfig artifactConfig,
                                                                                             String fileName,
                                                                                             Set<ExtensionModel> extensionModels,
                                                                                             Optional<ComponentBuildingDefinitionRegistry> componentBuildingDefinitionRegistry,
                                                                                             boolean runtimeMode,
                                                                                             ResourceProvider externalResourceProvider)
      throws Exception {
    return new ApplicationModel(artifactConfig, null,
                                extensionModels, Collections.emptyMap(),
                                Optional.empty(), componentBuildingDefinitionRegistry, runtimeMode, externalResourceProvider);
  }

  public static Optional<org.mule.runtime.config.internal.model.ApplicationModel> createInternalApplicationModel(String name,
                                                                                                                 InputStream inputStream) {
    return loadConfigLines(inputStream).map(configLine -> {
      try {
        return loadApplicationModel(configLine, name);
      } catch (Exception e) {
        throw new MuleRuntimeException(e);
      }
    });
  }
}
