package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.util.Utils;
import org.mule.datasense.impl.util.extension.DslElementModelWalker;
import org.mule.datasense.impl.util.extension.ExtensionUtils;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.api.dsl.model.DslElementModel;

import java.util.Optional;

public class StaticDslSourceAnnotator extends StaticDslBaseAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    final Optional<DslElementModel<SourceModel>> objectDslElementModel =
        annotatingMuleAstVisitorContext.getDataSenseProviderResolver().getDslElementModelFactory()
            .create(messageProcessorNode.getComponentModel().getConfiguration());
    objectDslElementModel.ifPresent(operationModelDslElementModel -> {
      messageProcessorNode.annotate(new SourceModelAnnotation(operationModelDslElementModel.getModel()));

      OperationCallBuilder operationCallBuilder =
          messageProcessorNode
              .getOrCreateAnnotation(OperationCallBuilderAnnotation.class,
                                     OperationCallBuilderAnnotation::new)
              .getOperationCallBuilder();

      final OperationCallDslElementModelVisitor dslElementModelVisitor =
          new OperationCallDslElementModelVisitor(operationCallBuilder);

      ExtensionUtils.findOutputMimeType(messageProcessorNode.getComponentModel()).ifPresent(outputMimeType -> {
        operationCallBuilder.outputMimeType(outputMimeType);
      });

      DslElementModelWalker dslElementModelWalker = new DslElementModelWalker();
      dslElementModelWalker.walkDslElementModel(operationModelDslElementModel, dslElementModelVisitor);

      if (dslElementModelVisitor.isHasDynamicType()) {
        messageProcessorNode.annotate(new HasDynamicMetadataAnnotation(dslElementModelVisitor.isIncompleteForDynamicMetadata()));
      }
    });
  }
}
