package org.mule.datasense.impl.phases.builder;

import com.google.common.base.Preconditions;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.runtime.config.internal.model.ComponentModel;

public abstract class DependenciesResolutionScopeStrategy implements DataSenseResolutionScopeStrategy {

  private final ApplicationModel applicationModel;
  private final DataSenseProvider dataSenseProvider;
  private final DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy;

  public DependenciesResolutionScopeStrategy(ApplicationModel applicationModel, DataSenseProvider dataSenseProvider,
                                             DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy) {
    Preconditions.checkNotNull(applicationModel);
    Preconditions.checkNotNull(dataSenseProvider);
    Preconditions.checkNotNull(dataSenseResolutionScopeStrategy);
    this.applicationModel = applicationModel;
    this.dataSenseProvider = dataSenseProvider;
    this.dataSenseResolutionScopeStrategy = dataSenseResolutionScopeStrategy;
  }

  @Override
  public boolean match(ComponentModel componentModel) {
    return dataSenseResolutionScopeStrategy.match(componentModel);
  }

  protected ApplicationModel getApplicationModel() {
    return applicationModel;
  }

  protected DataSenseProvider getDataSenseProvider() {
    return dataSenseProvider;
  }

  protected DataSenseResolutionScopeStrategy getDataSenseResolutionScopeStrategy() {
    return dataSenseResolutionScopeStrategy;
  }
}
