package org.mule.datasense.impl.phases.builder;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.ObjectUtils;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MinimalAppDependenciesResolutionScopeStrategy extends DependenciesResolutionScopeStrategy {

  public MinimalAppDependenciesResolutionScopeStrategy(ApplicationModel applicationModel, DataSenseProvider dataSenseProvider,
                                                       DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy) {
    super(applicationModel, dataSenseProvider, dataSenseResolutionScopeStrategy);
    init();
  }

  private LazyComponentInitializer.ComponentLocationFilter getComponentLocationFilter(
                                                                                      List<ComponentLocation> filteredComponentLocations) {
    return currentComponentLocation -> filteredComponentLocations.stream()
        .anyMatch(
                  filteredComponentLocation -> ObjectUtils.equals(filteredComponentLocation
                      .getLocation(), currentComponentLocation
                          .getLocation()));
  }

  private void init() {
    final org.mule.runtime.config.internal.model.ApplicationModel muleApplicationModel =
        getApplicationModel().getMuleApplicationModel();

    List<ComponentLocation> componentLocations = new ArrayList<>();
    muleApplicationModel.executeOnEveryFlow(componentModel -> {
      if (getDataSenseResolutionScopeStrategy().match(componentModel)) {
        componentLocations.add(componentModel.getComponentLocation());
      }
    });

    final Set<ExtensionModel> extensionModels = getDataSenseProvider().getExtensions();

    //    updateMinimalApplicationModel(muleApplicationModel, extensionModels, getComponentLocationFilter(componentLocations));
  }

  /*
  private static void updateMinimalApplicationModel(
      org.mule.runtime.config.internal.model.ApplicationModel muleApplicationModel,
      Set<ExtensionModel> extensions,
      LazyComponentInitializer.ComponentLocationFilter componentLocationFilter) {
  
    muleApplicationModel.executeOnEveryComponentTree(componentModel -> {
      componentModel.setEnabled(false);
    });
  
    final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = createComponentBuildingDefinitionRegistry(extensions, Thread.currentThread().getContextClassLoader());
    final ConfigurationDependencyResolver dependencyResolver =
        new ConfigurationDependencyResolver(muleApplicationModel,
                                            componentBuildingDefinitionRegistry);
    final MinimalApplicationModelGenerator minimalApplicationModelGenerator =
        new MinimalApplicationModelGenerator(dependencyResolver);
    minimalApplicationModelGenerator.getMinimalModel(componentLocationFilter);
  }
  
  private static ComponentBuildingDefinitionRegistry createComponentBuildingDefinitionRegistry(
      Set<ExtensionModel> extensionModels,
      ClassLoader classLoader) {
    ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry =
        new ComponentBuildingDefinitionRegistry();
    serviceRegistry.lookupProviders(ComponentBuildingDefinitionProvider.class, classLoader)
        .forEach(componentBuildingDefinitionProvider -> {
          if (componentBuildingDefinitionProvider instanceof ExtensionBuildingDefinitionProvider) {
            ((ExtensionBuildingDefinitionProvider) componentBuildingDefinitionProvider)
                .setExtensionModels(extensionModels);
          }
          componentBuildingDefinitionProvider.init();
          componentBuildingDefinitionProvider.getComponentBuildingDefinitions()
              .forEach(componentBuildingDefinitionRegistry::register);
        });
    return componentBuildingDefinitionRegistry;
  }
  */

  @Override
  public boolean match(ComponentModel componentModel) {
    return super.match(componentModel) || (componentModel.isEnabled());
  }
}
