package org.mule.datasense.impl.phases.typing.resolver;

import org.jetbrains.annotations.NotNull;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.runtime.api.component.ComponentIdentifier;

import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_PARALLEL_FOREACH_SCOPE_IN;

public class ParallelForEachTypeResolver extends ForEachTypeResolver {

  private static final String DEFAULT_INDEX_VARIABLE_NAME = "index";

  protected EventType resolveOutputEventType(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                                             EventType innerEventType, TypingMuleAstVisitor typingMuleAstVisitor,
                                             TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
    final ScatterGatherTypeResolver.CollectStrategy collectStrategy = new ScatterGatherTypeResolver.ListCollectStrategy();
    if (innerEventType != null) {
      collectStrategy.processMessageProcessorOutput(messageProcessorNode, innerEventType);
    }
    EventType outputEventType = collectStrategy.build();

    outputEventType = processTarget(outputEventType, messageProcessorNode, typingMuleAstVisitorContext);
    messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));

    return outputEventType;
  }

  protected ComponentIdentifier getComponentIdentifierForeachScopeIn() {
    return COMPONENT_IDENTIFIER_PARALLEL_FOREACH_SCOPE_IN;
  }

  public static class ParallelForEachScopeIn extends ForEachTypeResolver.ForEachScopeIn {

    @NotNull
    protected String getDefaultCounterVariableName() {
      return DEFAULT_INDEX_VARIABLE_NAME;
    }
  }
}
