package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.ArrayList;
import java.util.List;

public class ErrorMapper {

  private final List<ErrorMapping> errorMappings;

  public ErrorMapper(List<ErrorMapping> errorMappings) {
    this.errorMappings = new ArrayList<>();
    this.errorMappings.addAll(errorMappings);
  }

  public ErrorModel map(ErrorModel errorModel) {
    ErrorModel result = errorModel;
    for (ErrorMapping errorMapping : errorMappings) {
      if (errorMapping.matches(errorModel)) {
        result = errorMapping.getErrorModel();
        break;
      }
    }
    return result;
  }
}
