/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class GlobalBindingMetadataTypes
implements LogSupport {
    public static final String GLOBAL_BINDING_MULE = "mule";
    public static final String GLOBAL_BINDING_SERVER = "server";
    public static final String GLOBAL_BINDING_APP = "app";
    public static final String GLOBAL_BINDING_FLOW = "flow";
    public static final String GLOBAL_BINDING_CORRELATION_ID = "correlationId";
    public static final String GLOBAL_BINDING_DATA_TYPE = "dataType";
    public static final String GLOBAL_BINDING_AUTHENTICATION = "authentication";
    public static final String GLOBAL_BINDING_ITEM_SEQUENCE_INFO = "itemSequenceInfo";
    public static final String GLOBAL_BINDING_ERROR = "error";
    private static final String GLOBAL_BINDING_DATA_TYPE_CLASS = "org.mule.runtime.api.metadata.DataType";
    private static final String GLOBAL_BINDING_AUTHENTICATION_CLASS = "org.mule.runtime.api.security.Authentication";
    private static final String GLOBAL_BINDING_ITEM_SEQUENCE_INFO_CLASS = "org.mule.runtime.api.message.ItemSequenceInfo";
    private static final String ERROR_CLASS = "org.mule.runtime.api.message.Error";
    private static final String TYPEDVALUE_CLASS = "org.mule.runtime.api.metadata.TypedValue";
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final MetadataType correlationIdType;
    private final MetadataType dataTypeType;
    private final MetadataType authenticationType;
    private final MetadataType itemSequenceInfoType;
    private final MetadataType typedValueType;
    private final MetadataType appType;
    private final MetadataType serverType;
    private final MetadataType muleType;
    private final MetadataType errorType;
    private final MetadataType flowType;

    public static MetadataType getTypeFromJavaClass(String clazz) {
        return TypesHelper.getTypeFromJavaClass(clazz, GlobalBindingMetadataTypes.class.getClassLoader()).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve class type %s", clazz)));
    }

    private static Optional<MetadataType> getTypeFromWeave(String weaveTypeDef, String typeId, MetadataFormat metadataFormat, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        return expressionLanguageMetadataService.createTypeLoader(weaveTypeDef, Optional.ofNullable(metadataFormat).orElse(MetadataFormats.JAVA)).load(typeId);
    }

    private static Optional<MetadataType> getTypeFromWeave(String weaveTypeDef, String typeId, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        return GlobalBindingMetadataTypes.getTypeFromWeave(weaveTypeDef, typeId, null, expressionLanguageMetadataService);
    }

    private static MetadataType metadataTypeFromWeaveResource(String resource, String type, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        try {
            return GlobalBindingMetadataTypes.getTypeFromWeave(IOUtils.toString((InputStream)GlobalBindingMetadataTypes.class.getResourceAsStream(resource)), type, expressionLanguageMetadataService).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve weave type %s", type)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public GlobalBindingMetadataTypes(ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.correlationIdType = this.createCorrelationIdType();
        this.dataTypeType = this.createDataTypeType();
        this.authenticationType = this.createAuthenticationType();
        this.itemSequenceInfoType = this.createItemSequenceInfoType();
        this.typedValueType = this.createTypedValueType();
        this.appType = this.createAppType();
        this.serverType = this.createServerType();
        this.muleType = this.createMuleType();
        this.errorType = this.createErrorType();
        this.flowType = this.createFlowType();
    }

    private MetadataType createCorrelationIdType() {
        BaseTypeBuilder typeBuilder = TypesHelper.getTypeBuilder();
        typeBuilder.stringType();
        return typeBuilder.build();
    }

    public MetadataType correlationIdType() {
        return this.correlationIdType;
    }

    private MetadataType createDataTypeType() {
        return GlobalBindingMetadataTypes.getTypeFromJavaClass(GLOBAL_BINDING_DATA_TYPE_CLASS);
    }

    public MetadataType dataTypeType() {
        return this.dataTypeType;
    }

    private MetadataType createAuthenticationType() {
        return GlobalBindingMetadataTypes.getTypeFromJavaClass(GLOBAL_BINDING_AUTHENTICATION_CLASS);
    }

    public MetadataType authenticationType() {
        return this.authenticationType;
    }

    private MetadataType createItemSequenceInfoType() {
        return GlobalBindingMetadataTypes.getTypeFromJavaClass(GLOBAL_BINDING_ITEM_SEQUENCE_INFO_CLASS);
    }

    public MetadataType itemSequenceInfoType() {
        return this.itemSequenceInfoType;
    }

    private MetadataType createTypedValueType() {
        return GlobalBindingMetadataTypes.getTypeFromJavaClass(TYPEDVALUE_CLASS);
    }

    public MetadataType typedValueType() {
        return this.typedValueType;
    }

    private MetadataType createAppType() {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("app-type.dw", "DataWeaveArtifactContext", this.expressionLanguageMetadataService);
    }

    public MetadataType appType() {
        return this.appType;
    }

    private MetadataType createServerType() {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("server-type.dw", "ServerContext", this.expressionLanguageMetadataService);
    }

    public MetadataType serverType() {
        return this.serverType;
    }

    private MetadataType createMuleType() {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("mule-type.dw", "MuleInstanceContext", this.expressionLanguageMetadataService);
    }

    public MetadataType muleType() {
        return this.muleType;
    }

    private MetadataType createErrorType() {
        return TypesHelper.getTypeFromJavaClass(ERROR_CLASS, GlobalBindingMetadataTypes.class.getClassLoader()).orElse(ErrorHandlingUtils.errorType(Collections.emptySet()));
    }

    public MetadataType errorType() {
        return this.errorType;
    }

    private MetadataType createFlowType() {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("flow-type.dw", "NamedObject", this.expressionLanguageMetadataService);
    }

    public MetadataType flowType() {
        return this.flowType;
    }
}

