package org.mule.datasense.api.metadataprovider;

import java.io.InputStream;
import java.util.Optional;

public class ApplicationModelFromMuleConfigData extends BaseApplicationModelFactory {

  public Optional<ApplicationModel> create(String name, String muleConfigData) {
    return create(name, org.apache.commons.io.IOUtils.toInputStream(muleConfigData));
  }

  public Optional<ApplicationModel> create(String name, InputStream inputStream) {
    return createInternalApplicationModel(name, inputStream)
        .map(applicationModel -> new DefaultApplicationModel(name, applicationModel));
  }

}
