/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.api.metadataprovider;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;

import java.util.Optional;
import java.util.Set;

/**
 *
 */
public interface DataSenseProvider {

  /**
   *
   * @return
     */
  Set<ExtensionModel> getExtensions();

  /**
   *
   * @return
     */
  Optional<DataSenseMetadataProvider> getDataSenseMetadataProvider();


  Optional<DataSenseConfiguration> getDataSenseConfiguration();

  ExpressionLanguageMetadataService getExpressionLanguageMetadataService();

  ExpressionLanguage getExpressionLanguage();

  MetadataBuilder getApikitMetadataBuilder();

  /**
   * @return a configured {@link DslElementModelFactory} used to create {@link DslElementModel}s
   */
  DslElementModelFactory getDslElementModelFactory();

}
