package org.mule.datasense.api.metadataprovider;

import static java.util.Optional.ofNullable;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.model.ExtensionModel;

import com.google.common.base.Preconditions;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;

import java.util.Optional;
import java.util.Set;

public class DefaultDataSenseProvider implements DataSenseProvider {

  private final ExtensionsProvider extensionsProvider;
  private final DataSenseMetadataProvider dataSenseMetadataProvider;
  private final MetadataBuilder apikitMetadataBuilder;
  private DataSenseConfiguration dataSenseConfiguration;
  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
  private final ExpressionLanguage expressionLanguage;
  private final DslElementModelFactory dslElementModelFactory;

  public DefaultDataSenseProvider(ExtensionsProvider extensionsProvider, DataSenseMetadataProvider dataSenseMetadataProvider,
                                  DataSenseConfiguration dataSenseConfiguration,
                                  ExpressionLanguageMetadataService expressionLanguageMetadataService,
                                  ExpressionLanguage expressionLanguage,
                                  MetadataBuilder apikitMetadataBuilder,
                                  DslElementModelFactory dslElementModelFactory) {
    Preconditions.checkNotNull(extensionsProvider);
    this.extensionsProvider = extensionsProvider;
    this.dataSenseMetadataProvider = dataSenseMetadataProvider;
    this.dataSenseConfiguration = dataSenseConfiguration;
    this.expressionLanguage = expressionLanguage;
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    this.apikitMetadataBuilder = apikitMetadataBuilder;
    this.dslElementModelFactory = dslElementModelFactory;
  }

  @Override
  public Set<ExtensionModel> getExtensions() {
    return extensionsProvider.getExtensions();
  }

  @Override
  public DslElementModelFactory getDslElementModelFactory() {
    return this.dslElementModelFactory;
  }

  public Optional<DataSenseMetadataProvider> getDataSenseMetadataProvider() {
    return ofNullable(dataSenseMetadataProvider);
  }

  @Override
  public MetadataBuilder getApikitMetadataBuilder() {
    return apikitMetadataBuilder;
  }

  @Override
  public Optional<DataSenseConfiguration> getDataSenseConfiguration() {
    return ofNullable(dataSenseConfiguration);
  }

  @Override
  public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
    return expressionLanguageMetadataService;
  }

  @Override
  public ExpressionLanguage getExpressionLanguage() {
    return expressionLanguage;
  }

}
