package org.mule.datasense.impl.model.operation;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OperationCall {

  private String name;
  private final List<InputMapping> inputMappingList;
  private Map<String, InputMapping> inputMappingMap;
  private final Set<ErrorModel> errorModelSet;
  private final MetadataType returnType;
  private final String target;
  private final String targetValueExpression;
  private final String outputMimeType;

  public OperationCall(String name, Stream<InputMapping> inputMappings, Set<ErrorModel> errorModelSet, MetadataType returnType,
                       String target,
                       String targetValueExpression, String outputMimeType) {
    this.name = name;
    this.inputMappingList = inputMappings.collect(Collectors.toList());
    this.errorModelSet = errorModelSet;
    this.returnType = returnType;
    this.target = target;
    this.targetValueExpression = targetValueExpression;
    this.outputMimeType = outputMimeType;
    inputMappingMap = new HashMap<>();
    inputMappingList.forEach(inputMapping -> {
      inputMappingMap.put(inputMapping.getInputParameter().getName(), inputMapping);
    });
  }

  public String getName() {
    return name;
  }

  public Stream<InputMapping> getInputMappings() {
    return inputMappingList.stream();
  }

  public Optional<InputMapping> getInputMapping(String parameterName) {
    return Optional.ofNullable(inputMappingMap.get(parameterName));
  }

  public MetadataType getReturnType() {
    return returnType;
  }

  public Optional<String> getTarget() {
    return Optional.ofNullable(target);
  }

  public String getTargetValueExpression() {
    return targetValueExpression;
  }

  public String getOutputMimeType() {
    return outputMimeType;
  }

  public Set<ErrorModel> getErrorModels() {
    return errorModelSet;
  }
}
