package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

import java.util.Collection;
import java.util.Optional;

import static java.util.stream.Collectors.toList;
import static org.mule.datasense.impl.DataSenseProviderResolver.isDynamicDataSenseSupportedFor;

abstract class BaseDynamicAnnotator<T extends ComponentModel> extends BaseExtensionAnnotator {

  private boolean requiresDynamicMetadataResolution(MessageProcessorNode messageProcessorNode,
                                                    AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    final Optional<HasDynamicMetadataAnnotation> maybeHasDynamicMetadataAnnotation =
        messageProcessorNode.getAnnotation(HasDynamicMetadataAnnotation.class);

    if (!maybeHasDynamicMetadataAnnotation.isPresent()) {
      return false;
    }

    boolean result = true;

    final HasDynamicMetadataAnnotation hasDynamicMetadataAnnotation = maybeHasDynamicMetadataAnnotation.get();
    final Collection<ParameterModel> incompleteParameters = hasDynamicMetadataAnnotation.getIncompleteParameters();
    if (incompleteParameters != null && incompleteParameters.size() > 0) {
      annotatingMuleAstVisitorContext.getAstNotification()
          .reportError(messageProcessorNode.getAstNodeLocation(),
                       NotificationMessages
                           .MSG_DYNAMIC_METADATA_RESOLUTION_SKIPPED_CAUSE_INCOMPLETE_PARAMETERS(incompleteParameters.stream()
                               .map(NamedObject::getName).collect(toList())));

      result = false;
    }

    return result;
  }

  @Override
  protected Optional<org.mule.runtime.api.meta.model.ComponentModel> resolveComponentModel(
                                                                                           MessageProcessorNode messageProcessorNode,
                                                                                           AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext,
                                                                                           DataSenseProviderResolver dataSenseProviderResolver,
                                                                                           org.mule.runtime.config.internal.model.ComponentModel componentModel) {
    Optional<org.mule.runtime.api.meta.model.ComponentModel> result = Optional.empty();

    boolean requiresDynamicMetadataResolution =
        requiresDynamicMetadataResolution(messageProcessorNode, annotatingMuleAstVisitorContext);
    if (requiresDynamicMetadataResolution) {
      result = dataSenseProviderResolver.getDataSenseProvider().getDataSenseMetadataProvider().flatMap(
                                                                                                       dataSenseMetadataProvider -> annotatingMuleAstVisitorContext
                                                                                                           .getAnnotation(MuleFlowAnnotation.class)
                                                                                                           .map(
                                                                                                                muleFlowAnnotation -> messageProcessorNode
                                                                                                                    .getAnnotation(ComponentLocationAnnotation.class)
                                                                                                                    .map(componentPathAnnotation -> {
                                                                                                                      org.mule.runtime.api.meta.model.ComponentModel metadataComponentModel =
                                                                                                                          null;
                                                                                                                      MetadataResult<T> metadataResult =
                                                                                                                          null;
                                                                                                                      if (isDynamicDataSenseSupportedFor(messageProcessorNode)) {
                                                                                                                        metadataResult =
                                                                                                                            resolveMetadata(messageProcessorNode,
                                                                                                                                            dataSenseMetadataProvider,
                                                                                                                                            componentPathAnnotation,
                                                                                                                                            annotatingMuleAstVisitorContext);
                                                                                                                      }
                                                                                                                      if (metadataResult != null) {
                                                                                                                        if (!metadataResult
                                                                                                                            .isSuccess()) {
                                                                                                                          metadataResult
                                                                                                                              .getFailures()
                                                                                                                              .forEach(metadataFailure -> {
                                                                                                                                annotatingMuleAstVisitorContext
                                                                                                                                    .getAstNotification()
                                                                                                                                    .reportError(messageProcessorNode
                                                                                                                                        .getAstNodeLocation(),
                                                                                                                                                 NotificationMessages
                                                                                                                                                     .MSG_FAILED_TO_RESOLVE_DYNAMIC_MODEL(metadataFailure),
                                                                                                                                                 metadataFailure
                                                                                                                                                     .getFailureCode(),
                                                                                                                                                 metadataFailure
                                                                                                                                                     .getFailingComponent(),
                                                                                                                                                 metadataFailure
                                                                                                                                                     .getFailingElement()
                                                                                                                                                     .orElse(null),
                                                                                                                                                 NotificationMessages
                                                                                                                                                     .REASON_FAILED_TO_RESOLVE_DYNAMIC_MODEL(metadataFailure));
                                                                                                                              });
                                                                                                                        }
                                                                                                                        metadataComponentModel =
                                                                                                                            metadataResult
                                                                                                                                .get();
                                                                                                                      }
                                                                                                                      return metadataComponentModel;
                                                                                                                    })))
          .orElse(Optional.empty());
    }
    return result;
  }

  protected abstract MetadataResult<T> resolveMetadata(
                                                       MessageProcessorNode messageProcessorNode,
                                                       DataSenseMetadataProvider dataSenseMetadataProvider,
                                                       ComponentLocationAnnotation componentLocationAnnotation,
                                                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext);

}
