package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.api.metadataprovider.CompatibleComponentAst;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

import java.util.Optional;

public class DynamicSourceAnnotator extends BaseDynamicAnnotator<SourceModel> {

  protected MetadataResult<SourceModel> resolveMetadata(MessageProcessorNode messageProcessorNode,
                                                        DataSenseMetadataProvider dataSenseMetadataProvider,
                                                        ComponentLocationAnnotation componentLocationAnnotation,
                                                        AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {

    Optional<SourceModelAnnotation> sourceModelAnnotation =
        messageProcessorNode.getAnnotation(SourceModelAnnotation.class);
    if (!sourceModelAnnotation.isPresent()) {
      annotatingMuleAstVisitorContext.getAstNotification()
          .reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory
              .createStaticMessage(NotificationMessages.MSG_FAILED_TO_OBTAIN_METADATA,
                                   "source metadata for component_path: "
                                       + componentLocationAnnotation.getLocation()
                                       + " due to source model annotation not present"));
      return null;
    }


    final MetadataResult<SourceModel> sourceMetadata =
        dataSenseMetadataProvider.getSourceMetadata(new CompatibleComponentAst(messageProcessorNode.getComponentModel(),
                                                                               componentLocationAnnotation.getLocation(),
                                                                               sourceModelAnnotation.get().getSourceModel()));
    if (sourceMetadata != null) {
      if (sourceMetadata.isSuccess()) {
        final SourceModel sourceModel = sourceMetadata.get();
        messageProcessorNode.annotate(new SourceModelAnnotation(sourceModel));
      }
    } else {
      annotatingMuleAstVisitorContext.getAstNotification()
          .reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory
              .createStaticMessage(NotificationMessages.MSG_FAILED_TO_OBTAIN_METADATA,
                                   "source metadata for component_path: " + componentLocationAnnotation.getLocation()));

    }
    return sourceMetadata;
  }
}
