package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import com.google.common.base.Strings;
import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

import static java.lang.String.format;

public class ErrorTreeUtils {

  private static void log(Object o) {
    System.out.println(o);
  }

  public static void dump(ErrorNode errorNode) {
    errorNode.accept(new ErrorNode.ErrorNodeVisitor() {

      private int level;

      private void println(Object o) {
        log(Strings.repeat("\t", level) + o);
      }

      @Override
      public void visit(ErrorNode errorNode) {
        //                println(errorNode.getErrorModel().map(errorModel -> format("%s:%s (#%s > #%s)", errorModel.getNamespace(), errorModel.getType(), errorModel, errorModel.getParent().map(errorType1 -> String.valueOf(errorType1)).orElse(""))).orElse("root")  );
        println(errorNode.getErrorModel().map(errorModel -> format("%s:%s", errorModel.getNamespace(), errorModel.getType()))
            .orElse("root"));
        level++;
        errorNode.getChildren().forEach(this::visit);
        level--;
      }
    });
  }

  private static Iterable<ErrorModel> buildErrorTypePath(ErrorModel errorType) {
    Deque<ErrorModel> errorTypePath = new ArrayDeque<>();
    ErrorModel currentErrorModel = errorType;
    while (currentErrorModel != null) {
      errorTypePath.push(currentErrorModel);
      currentErrorModel = currentErrorModel.getParent().orElse(null);
    }
    return errorTypePath;
  }

  private static void add(ErrorNode errorNode, ErrorModel errorModel) {
    Iterable<ErrorModel> errorTypePath = buildErrorTypePath(errorModel);
    errorNode.add(errorTypePath.iterator(), null);
  }

  public static ErrorNode createTree(Iterable<ErrorModel> errorModels) {
    ErrorNode result = new ErrorNode(null);
    errorModels.forEach(errorType -> {
      add(result, errorType);
    });
    return result;
  }

}
