package org.mule.datasense.impl.util;

import static java.util.Optional.empty;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class LocationUtils {

  public static boolean isFlow(Location location) {
    return location.getParts().size() == 0;
  }

  public static Location valueOf(String location) {
    return Location.builderFromStringRepresentation(location).build();
  }

  private static List<DefaultComponentLocation.DefaultLocationPart> asLocationParts(List<String> parts) {
    if (parts == null) {
      return null;
    }

    List<DefaultComponentLocation.DefaultLocationPart> result = new ArrayList<>();

    parts.forEach(part -> {
      result.add(new DefaultComponentLocation.DefaultLocationPart(part, empty(), empty(), empty(), empty()));
    });

    return result;
  }

  public static ComponentLocation asComponentLocation(String name, Location location) {
    List<String> parts = new ArrayList<>();
    parts.add(location.getGlobalName());
    parts.addAll(location.getParts());
    return new DefaultComponentLocation(Optional.ofNullable(name), asLocationParts(parts));
  }
}
