package org.mule.datasense.impl.util.extension;

import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;

public class OperationModelTransform extends EntityModelTransform {

  public OperationModelTransform(
                                 ParameterGroupModelTransform parameterGroupModelTransform,
                                 OutputModelTransform outputModelTransform,
                                 OutputModelTransform outputAttributesModelTransform) {
    super(parameterGroupModelTransform, outputModelTransform, outputAttributesModelTransform);
  }

  public OperationModel transform(OperationModel operationModel) {
    return new ImmutableOperationModel(operationModel.getName(), operationModel.getDescription(),
                                       parameterGroupModelTransform.transform(operationModel.getParameterGroupModels()),
                                       operationModel.getNestedComponents(),
                                       outputModelTransform.transform(operationModel.getOutput()),
                                       outputAttributesModelTransform.transform(operationModel.getOutputAttributes()),
                                       operationModel.isBlocking(),
                                       operationModel.getExecutionType(), operationModel.requiresConnection(),
                                       operationModel.isTransactional(), operationModel.isTransactional(),
                                       operationModel.getDisplayModel().orElse(null),
                                       operationModel.getErrorModels(),
                                       operationModel.getStereotype(),
                                       operationModel.getModelProperties(),
                                       operationModel.getNotificationModels());
  }
}
