/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.api.metadataprovider;

import java.util.Optional;
import java.util.Set;
import org.mule.datasense.api.metadataprovider.CompatibleComponentAst;
import org.mule.datasense.api.metadataprovider.DataSenseConfiguration;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDataSenseProvider
implements DataSenseProvider {
    static final transient Logger logger = LoggerFactory.getLogger(CachedDataSenseProvider.class);
    private final DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider;
    private final DataSenseProvider delegate;

    public CachedDataSenseProvider(DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider, DataSenseProvider delegate) {
        this.delegate = delegate;
        this.dataSenseMetadataCacheProvider = dataSenseMetadataCacheProvider;
    }

    @Override
    public Set<ExtensionModel> getExtensions() {
        return this.delegate.getExtensions();
    }

    @Override
    public Optional<DataSenseMetadataProvider> getDataSenseMetadataProvider() {
        return this.delegate.getDataSenseMetadataProvider().map(dataSenseMetadataProvider -> new CachedDataSenseMetadataProvider((DataSenseMetadataProvider)dataSenseMetadataProvider, this.dataSenseMetadataCacheProvider));
    }

    @Override
    public Optional<DataSenseConfiguration> getDataSenseConfiguration() {
        return this.delegate.getDataSenseConfiguration();
    }

    @Override
    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.delegate.getExpressionLanguageMetadataService();
    }

    @Override
    public ExpressionLanguage getExpressionLanguage() {
        return this.delegate.getExpressionLanguage();
    }

    @Override
    public MetadataBuilder getApikitMetadataBuilder() {
        return this.delegate.getApikitMetadataBuilder();
    }

    @Override
    public DslElementModelFactory getDslElementModelFactory() {
        return this.delegate.getDslElementModelFactory();
    }

    private class CachedDataSenseMetadataProvider
    implements DataSenseMetadataProvider {
        private final DataSenseMetadataProvider delegate;
        private final DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider;

        public CachedDataSenseMetadataProvider(DataSenseMetadataProvider delegate, DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider) {
            this.delegate = delegate;
            this.dataSenseMetadataCacheProvider = dataSenseMetadataCacheProvider;
        }

        public DataSenseMetadataProvider getDelegate() {
            return this.delegate;
        }

        @Override
        public MetadataResult<OperationModel> getOperationMetadata(CompatibleComponentAst componentModelAst) {
            try {
                return this.dataSenseMetadataCacheProvider.getOperationMetadata(componentModelAst, () -> Optional.ofNullable(this.getDelegate().getOperationMetadata(componentModelAst)).orElseThrow(() -> new RuntimeException(String.format("Failed to resolve operation metadata for component path %s.", componentModelAst.getLocation()))));
            }
            catch (Exception e) {
                logger.error(String.format("Failed to resolve operation metadata for component path %s.", componentModelAst.getLocation()), (Throwable)e);
                return null;
            }
        }

        @Override
        public MetadataResult<SourceModel> getSourceMetadata(CompatibleComponentAst componentModelAst) {
            try {
                return this.dataSenseMetadataCacheProvider.getSourceMetadata(componentModelAst, () -> Optional.ofNullable(this.getDelegate().getSourceMetadata(componentModelAst)).orElseThrow(() -> new RuntimeException(String.format("Failed to resolve source metadata for component path %s.", componentModelAst.getLocation()))));
            }
            catch (Exception e) {
                logger.error(String.format("Failed to resolve source metadata for component path %s.", componentModelAst.getLocation()), (Throwable)e);
                return null;
            }
        }

        @Override
        public MetadataResult<MetadataKeysContainer> getMetadataKeys(CompatibleComponentAst componentModelAst) {
            try {
                return this.dataSenseMetadataCacheProvider.getMetadataKeys(componentModelAst, () -> Optional.ofNullable(this.getDelegate().getMetadataKeys(componentModelAst)).orElseThrow(() -> new RuntimeException(String.format("Failed to resolve metadata keys for component path %s.", componentModelAst.getLocation()))));
            }
            catch (Exception e) {
                logger.error(String.format("Failed to resolve metadata keys for component path %s.", componentModelAst.getLocation()), (Throwable)e);
                return null;
            }
        }
    }
}

