/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Arrays;
import java.util.List;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.annotations.VoidOperationAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.BaseAnnotator;
import org.mule.datasense.impl.phases.annotators.OperationAnnotator;
import org.mule.datasense.impl.phases.annotators.SourceAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;

public class OperationCallAnnotator
extends BaseAnnotator {
    private static final List<ComponentIdentifier> whiteListedOperations = Arrays.asList(DefaultDataSense.COMPONENT_IDENTIFIER_SET_PAYLOAD, DefaultDataSense.COMPONENT_IDENTIFIER_SET_VARIABLE, DefaultDataSense.COMPONENT_IDENTIFIER_SET_PAYLOAD_ATTRIBUTES);
    private final SourceAnnotator sourceAnnotator = new SourceAnnotator();
    private final OperationAnnotator operationAnnotator = new OperationAnnotator();

    private static boolean isWhiteListedOperation(MessageProcessorNode messageProcessorNode) {
        return whiteListedOperations.contains(messageProcessorNode.getComponentIdentifier());
    }

    @Override
    public void annotate(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        if (!messageProcessorNode.isRootMessageProcessorNode()) {
            if (!messageProcessorNode.getAnnotation(TypeResolverAnnotation.class).isPresent()) {
                this.annotateOperationCall(messageProcessorNode, annotatingMuleAstVisitorContext, DefaultDataSense.COMPONENT_IDENTIFIER_OPERATION_CALL);
            } else if (OperationCallAnnotator.isWhiteListedOperation(messageProcessorNode)) {
                this.annotateOperationCall(messageProcessorNode, annotatingMuleAstVisitorContext);
            }
        }
    }

    private void annotateOperationCall(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext, ComponentIdentifier typeResolver) {
        messageProcessorNode.getComponentModelType().ifPresent(componentModelType -> {
            switch (componentModelType) {
                case MESSAGE_PROCESSOR_NODE: {
                    this.operationAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
                    break;
                }
                case MESSAGE_SOURCE_NODE: {
                    this.sourceAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
                }
            }
        });
        messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class).ifPresent(operationCallBuilderAnnotation -> {
            OperationCallBuilder operationCallBuilder = operationCallBuilderAnnotation.getOperationCallBuilder();
            OperationCall operationCall = operationCallBuilder.build();
            if (this.isVoidOperation(operationCall)) {
                messageProcessorNode.annotate(new VoidOperationAnnotation());
            }
            messageProcessorNode.annotate(new OperationCallAnnotation(operationCall));
            if (typeResolver != null) {
                messageProcessorNode.annotate(new TypeResolverAnnotation(typeResolver));
            }
        });
    }

    private void annotateOperationCall(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        this.annotateOperationCall(messageProcessorNode, annotatingMuleAstVisitorContext, null);
    }

    private boolean isVoidOperation(OperationCall operationCall) {
        boolean result = false;
        MetadataType returnType = operationCall.getReturnType();
        if (returnType instanceof MessageMetadataType) {
            MessageMetadataType messageMetadataType = (MessageMetadataType)returnType;
            result = !(messageMetadataType.getPayloadType().isPresent() && !(messageMetadataType.getPayloadType().get() instanceof VoidType) || messageMetadataType.getAttributesType().isPresent() && !(messageMetadataType.getAttributesType().get() instanceof VoidType));
        }
        return result;
    }
}

