/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.munit;

import java.util.Map;
import java.util.Optional;
import org.mule.datasense.impl.model.event.ExprBuilder;
import org.mule.datasense.impl.model.event.LiteralValueExprBuilder;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

public class MUnitSetEventParser {
    private static final ComponentIdentifier VARIABLES = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/munit", "variables");
    private static final ComponentIdentifier VARIABLE = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/munit", "variable");
    private static final ComponentIdentifier PAYLOAD = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/munit", "payload");
    private static final ComponentIdentifier ATTRIBUTES = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/munit", "attributes");
    private static final String ATTR_VARIABLE_NAME = "key";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_MEDIA_TYPE = "mediaType";

    private ExprBuilder buildExprBuilder(String textContent, String attributeValue, String mediaType) {
        String expression;
        if (textContent != null && textContent.trim().isEmpty()) {
            textContent = null;
        }
        ExprBuilder exprBuilder = (expression = (String)Optional.ofNullable(textContent).orElse(ExpressionLanguageUtils.extractExpression(attributeValue).orElse(null))) != null ? new SimpleExprBuilder(expression) : new LiteralValueExprBuilder(attributeValue);
        exprBuilder.mimeType(mediaType);
        return exprBuilder;
    }

    private void parseVariables(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder) {
        componentModel.getInnerComponents().forEach(childComponentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
            Map parameters = childComponentModel.getParameters();
            if (VARIABLE.equals(componentIdentifier)) {
                String name = (String)childComponentModel.getParameters().get(ATTR_VARIABLE_NAME);
                ExprBuilder exprBuilder = this.buildExprBuilder(childComponentModel.getTextContent(), (String)parameters.get(ATTR_VALUE), (String)parameters.get(ATTR_MEDIA_TYPE));
                muleEventExprBuilder.variable(name, v -> v.value(new ValueExprBuilder(exprBuilder)));
            }
        });
    }

    public void parse(ComponentModel setEventComponentModel, MuleEventExprBuilder muleEventExprBuilder) {
        setEventComponentModel.getInnerComponents().forEach(componentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
            Map parameters = componentModel.getParameters();
            if (PAYLOAD.equals(componentIdentifier)) {
                ExprBuilder exprBuilder = this.buildExprBuilder(componentModel.getTextContent(), (String)parameters.get(ATTR_VALUE), (String)parameters.get(ATTR_MEDIA_TYPE));
                muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(exprBuilder)));
            } else if (ATTRIBUTES.equals(componentIdentifier)) {
                ExprBuilder exprBuilder = this.buildExprBuilder(componentModel.getTextContent(), (String)parameters.get(ATTR_VALUE), (String)parameters.get(ATTR_MEDIA_TYPE));
                muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(exprBuilder)));
            } else if (VARIABLES.equals(componentIdentifier)) {
                this.parseVariables((ComponentModel)componentModel, muleEventExprBuilder);
            }
        });
    }
}

