package org.mule.datasense.impl.phases.builder;

import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ERROR_HANDLER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_GLOBAL_ERROR_HANDLER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MULE_HTTP_POLICY_PROXY;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SUBFLOW;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MuleAstParser {

  public static final String MULE_CORE = "http://www.mulesoft.org/schema/mule/core";
  public static final String MULE_CORE_PREFIX = "mule";
  public static final String MULE_EE_CORE = "http://www.mulesoft.org/schema/mule/ee/core";
  public static final String MULE_EE_CORE_PREFIX = "ee";
  public static final String MULE_EE_BATCH = "http://www.mulesoft.org/schema/mule/batch";
  public static final String MULE_EE_BATCH_PREFIX = "batch";
  public static final String MULE_MUNIT = "http://www.mulesoft.org/schema/mule/munit";
  public static final String MULE_MUNIT_PREFIX = "munit";
  public static final String MULE_AGGREGATORS = "http://www.mulesoft.org/schema/mule/aggregators";
  public static final String MULE_AGGREGATORS_PREFIX = "aggregators";
  public static final String MULE_HTTP_POLICY = "http://www.mulesoft.org/schema/mule/http-policy";
  public static final String MULE_HTTP_POLICY_PREFIX = "http-policy";

  private static Set<ComponentIdentifier> FLOW_COMPONENT_IDENTIFIERS =
      Stream.of(
                COMPONENT_IDENTIFIER_FLOW,
                COMPONENT_IDENTIFIER_SUBFLOW,
                COMPONENT_IDENTIFIER_MUNIT_TEST,
                COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST,
                COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST,
                COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE,
                COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE,
                COMPONENT_IDENTIFIER_ERROR_HANDLER,
                COMPONENT_IDENTIFIER_MULE_HTTP_POLICY_PROXY)
          .collect(Collectors.toSet());

  public Optional<AstNodeBuilder> parse(ComponentAst componentModel, MuleAstParserContext muleAstParserContext) {
    muleAstParserContext.enter(componentModel);
    Optional<AstNodeBuilder> result = Optional.empty();
    ComponentIdentifier componentIdentifier = componentModel.getIdentifier();

    if (FLOW_COMPONENT_IDENTIFIERS.contains(componentIdentifier) && componentModel.getComponentId().isPresent()) {
      MuleFlowNodeBuilder muleFlowNodeBuilder =
          new MuleFlowNodeBuilder(componentModel.getIdentifier());
      muleFlowNodeBuilder.config(componentModel);
      boolean traverse = muleAstParserContext.getDataSenseResolutionScopeStrategy()
          .map(dataSenseResolutionScopeStrategy -> dataSenseResolutionScopeStrategy.match(componentModel)).orElse(true);
      if (traverse) {
        ComponentIdentifier customizedComponentIdentifier = componentIdentifier;
        if (COMPONENT_IDENTIFIER_ERROR_HANDLER.equals(componentIdentifier)) {
          customizedComponentIdentifier = COMPONENT_IDENTIFIER_GLOBAL_ERROR_HANDLER;
        }
        getAstNodeBuilder(componentModel, muleAstParserContext, customizedComponentIdentifier).ifPresent(astNodeBuilder -> {
          if (astNodeBuilder instanceof MessageProcessorNodeBuilder) {
            final MessageProcessorNodeBuilder messageProcessorNodeBuilder = (MessageProcessorNodeBuilder) astNodeBuilder;
            muleFlowNodeBuilder.messageProcessor(messageProcessorNodeBuilder);
          }
        });
        /*
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        componentModel.getInnerComponents()
            .stream()
            .map(innerComponentModel -> parse(innerComponentModel, muleAstParserContext))
            .filter(Optional::isPresent)
            .map(Optional::get)
            .filter(astNodeBuilder -> astNodeBuilder instanceof MessageProcessorNodeBuilder)
            .map(astNodeBuilder -> (MessageProcessorNodeBuilder) astNodeBuilder)
            .forEach(messageProcessorNodeBuilder::messageProcessor);
        muleFlowNodeBuilder.messageProcessor(messageProcessorNodeBuilder);
        */
      }
      result = Optional.of(muleFlowNodeBuilder);
    } else {
      result = getAstNodeBuilder(componentModel, muleAstParserContext, componentIdentifier);
    }

    if (!result.isPresent()) {
      muleAstParserContext.astlogger().debug("Ignoring unknown element " + componentIdentifier);
    }

    muleAstParserContext.exit(componentModel);
    return result;
  }

  private Optional<AstNodeBuilder> getAstNodeBuilder(ComponentAst componentModel, MuleAstParserContext muleAstParserContext,
                                                     ComponentIdentifier componentIdentifier) {
    Optional<AstNodeBuilder> result;
    result = muleAstParserContext.getComponentModelType(componentModel).map(componentModelType -> {

      final Stream<MessageProcessorNodeBuilder> messageProcessorNodeBuilders =
          componentModel.directChildrenStream()
              .map(innerComponentModel -> parse(innerComponentModel, muleAstParserContext))
              .filter(Optional::isPresent)
              .map(Optional::get)
              .filter(astNodeBuilder -> astNodeBuilder instanceof MessageProcessorNodeBuilder)
              .map(astNodeBuilder -> (MessageProcessorNodeBuilder) astNodeBuilder);

      final MuleAstParseProvider parseProvider = muleAstParserContext.getParseProvider(componentModel).orElse(null);
      if (parseProvider != null) {
        return parseProvider.parse(componentIdentifier, componentModel, componentModelType,
                                   messageProcessorNodeBuilders.collect(Collectors.toList()), muleAstParserContext)
            .orElse(null);
      } else {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        messageProcessorNodeBuilder.componentModelType(componentModelType);
        messageProcessorNodeBuilders
            .forEach(messageProcessorNodeBuilder::messageProcessor);
        return messageProcessorNodeBuilder;
      }
    });
    return result;
  }

}
