package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_CORE;
import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_CORE_PREFIX;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ErrorMappingUtils {

  private static final ComponentIdentifier ERROR_MAPPING =
      ComponentIdentifierUtils.createFromNamespaceAndName(MULE_CORE_PREFIX, MULE_CORE, "error-mapping");
  private static final String ATTR_SOURCE_TYPE = "sourceType";
  private static final String ATTR_TARGET_TYPE = "targetType";

  public static Optional<ErrorMapping> createErrorMapping(ComponentAst componentModel) {
    if (!ERROR_MAPPING.equals(componentModel.getIdentifier())) {
      return Optional.empty();
    }

    // TODO MULE-17709 Stop using the `getRawParameterValue` method
    return ErrorMapping.create(componentModel.getRawParameterValue(ATTR_SOURCE_TYPE).orElse(null),
                               componentModel.getRawParameterValue(ATTR_TARGET_TYPE).orElse(null));
  }

  public static Optional<ErrorMapper> createErrorMapper(MessageProcessorNode messageProcessorNode) {
    List<ErrorMapping> errorMappings = new ArrayList<>();
    Optional.ofNullable(messageProcessorNode.getComponentModel()).ifPresent(componentModel -> {
      componentModel.directChildrenStream()
          .forEach(childComponentModel -> {
            ErrorMappingUtils.createErrorMapping(childComponentModel).ifPresent(errorMappings::add);
          });
    });
    return Optional.ofNullable(errorMappings.isEmpty() ? null : new ErrorMapper(errorMappings));
  }
}
