/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExpr;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.enricher.EnricherParser;
import org.mule.metadata.message.api.MuleEventMetadataType;

public class EnricherTypeResolver
extends SingleNodeTypeResolver {
    private final EnricherParser enricherParser = new EnricherParser();

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        EventType outputEventType = new EventType();
        MessageProcessorNode nestedMessageProcessorNode = messageProcessorNode.getMessageProcessorNodes().findFirst().orElse(null);
        if (nestedMessageProcessorNode != null) {
            EventType nestedEventType = typingMuleAstVisitor.resolveType((AstNode)nestedMessageProcessorNode, inputEventType, typingMuleAstVisitorContext);
            MuleEventExprBuilder muleEventExprBuilder = this.enricherParser.parse(messageProcessorNode.getComponentModel());
            MuleEventExpr muleEventExpr = muleEventExprBuilder.build();
            ResolveTypeContext resolveTypeContext = new ResolveTypeContext(typingMuleAstVisitorContext.getExpressionLanguageMetadataService(), this.createMessageCallbackFactory(typingMuleAstVisitorContext.getAstNotification(), messageProcessorNode.getAstNodeLocation()), typingMuleAstVisitorContext.getTypeBindings());
            MuleEventMetadataType muleEventMetadataType = muleEventExpr.resolveType(TypeUtils.asMuleEventMetadataType(nestedEventType).build(), resolveTypeContext);
            outputEventType = TypeUtils.asEventType(muleEventMetadataType);
        }
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return TypeUtils.merge(inputEventType, outputEventType);
    }

    @Override
    protected EventType resolveInnerExpectedOutputEventType(EventType expectedOutputEventType, EventType expectedOutputInnerEventType, MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
        MuleEventExprBuilder muleEventExprBuilder = this.enricherParser.parse(messageProcessorNode.getComponentModel());
        MuleEventExpr muleEventExpr = muleEventExprBuilder.build();
        ResolveTypeContext resolveTypeContext = new ResolveTypeContext(visitorContext.getExpressionLanguageMetadataService(), this.createMessageCallbackFactory(visitorContext.getAstNotification(), messageProcessorNode.getAstNodeLocation()), visitorContext.getTypeBindings());
        MuleEventMetadataType muleEventMetadataType = muleEventExpr.resolveInputType(TypeUtils.asMuleEventMetadataType(expectedOutputEventType).build(), resolveTypeContext);
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }
}

