/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitor;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.datasense.impl.phases.typing.resolver.ProcessorChainTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.ast.api.ComponentAst;

public class OnErrorTypeResolver
extends ProcessorChainTypeResolver {
    private static final String ATTRIBUTE_TYPE = "type";
    private final boolean handles;

    public OnErrorTypeResolver(boolean handles) {
        this.handles = handles;
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        Set<ErrorModel> unhandledErrors = typingMuleAstVisitorContext.getErrorHandlingEnvironment().getContext().getUnhandledErrors();
        EventType usesEventType = new EventType(Stream.of(new VarDecl("#error#", ErrorHandlingUtils.errorType(unhandledErrors))));
        messageProcessorNode.annotate(new UsesTypeAnnotation(usesEventType));
        if (this.handles) {
            messageProcessorNode.getComponentModel().getParameter(ATTRIBUTE_TYPE).getValue().applyRight(errorMatchExpression -> typingMuleAstVisitorContext.getErrorHandlingEnvironment().handleErrors(ErrorHandlingUtils.createErrorMatcher((String)errorMatchExpression)));
        }
        EventType resolve = super.resolve(messageProcessorNode, inputEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
        return resolve;
    }

    @Override
    protected boolean definesErrorHandlingContext() {
        return false;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    public Optional<MuleAstParseProvider> getParseProvider() {
        return Optional.of((componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders, muleAstParserContext) -> this.generateAst(componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders));
    }

    private Optional<AstNodeBuilder> generateAst(ComponentIdentifier componentIdentifier, ComponentAst componentModel, ComponentModelType componentModelType, List<MessageProcessorNodeBuilder> messageProcessorNodeBuilders) {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        messageProcessorNodeBuilder.componentModelType(componentModelType);
        messageProcessorNodeBuilder.messageProcessor(DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_SCOPE_IN, m -> {
            m.config(componentModel);
            m.synthetic();
        });
        messageProcessorNodeBuilders.forEach(messageProcessorNodeBuilder::messageProcessor);
        return Optional.of(messageProcessorNodeBuilder);
    }

    public static class ScopeIn
    extends SingleNodeTypeResolver {
        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
            MetadataType errorType = this.findGlobalBindingMetadataTypes(visitorContext).map(GlobalBindingMetadataTypes::errorType).orElse(ErrorHandlingUtils.errorType(Collections.emptySet()));
            EventType definesEventType = visitorContext.getErrorHandlingEnvironment().getContext().getArgumentEventType().orElse(new EventType());
            definesEventType = TypeUtils.merge(definesEventType, new EventType(Stream.of(new VarDecl("#error#", errorType))));
            messageProcessorNode.annotate(new DefinesTypeAnnotation(definesEventType));
            return definesEventType;
        }

        @Override
        public EventType generateIncoming(MessageProcessorNode messageProcessorNode, IncomingAstVisitor incomingAstVisitor, IncomingAstVisitorContext visitorContext) {
            return super.generateIncoming(messageProcessorNode, incomingAstVisitor, visitorContext);
        }

        @Override
        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return false;
        }

        @Override
        protected boolean isScope() {
            return true;
        }

        @Override
        protected boolean definesErrorHandlingContext() {
            return false;
        }
    }
}

