/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.enricher;

import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class EnricherParser {
    static final ComponentIdentifier ENRICH = ComponentIdentifierUtils.createFromNamespaceAndName("mule", "http://www.mulesoft.org/schema/mule/core", "enrich");
    static final String ATTR_SOURCE = "source";
    static final String ATTR_TARGET = "target";

    private void processEnrichment(ComponentAst componentModel, MuleEventExprBuilder muleEventExprBuilder) {
        componentModel.getParameter(ATTR_SOURCE).getValue().applyLeft(expression -> {
            ComponentParameterAst target = componentModel.getParameter(ATTR_TARGET);
            if (target.getRawValue().equals("payload")) {
                muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(new SimpleExprBuilder((String)expression))));
            } else if (target.getRawValue().equals("attributes")) {
                muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(new SimpleExprBuilder((String)expression))));
            } else if (!ExpressionLanguageUtils.isExpression(target.getRawValue())) {
                muleEventExprBuilder.variable(target.getRawValue(), v -> v.value(new ValueExprBuilder(new SimpleExprBuilder((String)expression))));
            }
        });
    }

    public MuleEventExprBuilder parse(ComponentAst componentModel) {
        MuleEventExprBuilder muleEventExprBuilder = new MuleEventExprBuilder();
        this.processEnrichment(componentModel, muleEventExprBuilder);
        componentModel.directChildrenStream().forEach(childComponentModel -> {
            ComponentIdentifier componentIdentifier = childComponentModel.getIdentifier();
            if (ENRICH.equals(componentIdentifier)) {
                this.processEnrichment((ComponentAst)childComponentModel, muleEventExprBuilder);
            }
        });
        return muleEventExprBuilder;
    }
}

