/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.transform;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;

public class TransformParser {
    static final String MESSAGE = "message";
    static final String VARIABLES = "variables";
    static final String SET_PAYLOAD = "setPayload";
    static final String SET_ATTRIBUTES = "setAttributes";
    static final ComponentIdentifier SET_VARIABLE = ComponentIdentifierUtils.createFromNamespaceAndName("ee", "http://www.mulesoft.org/schema/mule/ee/core", "set-variable");
    static final String ATTR_VARIABLE_NAME = "variableName";
    static final String ATTR_RESOURCE = "resource";
    static final String SCRIPT_PARAMETER = "script";

    private Optional<String> findResourceExpression(String resource, TransformParserContext transformParserContext) {
        return transformParserContext.getResourceResolver().map(resourceResolver -> ((Optional)resourceResolver.apply(resource)).map(uri -> {
            try {
                return FileUtils.readFileToString((File)FileUtils.toFile((URL)uri.toURL()));
            }
            catch (Exception e) {
                transformParserContext.getAstNotification().ifPresent(astNotification -> astNotification.reportError(transformParserContext.getAstNodeLocation().orElse(null), NotificationMessages.MSG_RESOURCE_NOT_FOUND(resource)));
                return null;
            }
        })).orElse(Optional.empty());
    }

    private Optional<String> findExpression(ComponentAst componentModel, TransformParserContext transformParserContext) {
        Either resolvedResource = componentModel.getParameter(ATTR_RESOURCE).getValue().mapRight(resource -> this.findResourceExpression((String)resource, transformParserContext));
        if (resolvedResource.isRight()) {
            return (Optional)resolvedResource.getRight();
        }
        return Optional.ofNullable((String)componentModel.getParameter(SCRIPT_PARAMETER).getValue().getRight());
    }

    public void parseVariables(List<ComponentAst> componentModels, MuleEventExprBuilder muleEventExprBuilder, TransformParserContext transformParserContext) {
        componentModels.stream().forEach(childComponentModel -> {
            ComponentIdentifier componentIdentifier = childComponentModel.getIdentifier();
            if (SET_VARIABLE.equals(componentIdentifier)) {
                childComponentModel.getParameter(ATTR_VARIABLE_NAME).getValue().applyRight(name -> this.findExpression((ComponentAst)childComponentModel, transformParserContext).ifPresent(expression -> muleEventExprBuilder.variable((String)name, v -> v.value(new ValueExprBuilder(new SimpleExprBuilder((String)expression))))));
            }
        });
    }

    public MuleEventExprBuilder parse(ComponentAst transformComponentModel, TransformParserContext transformParserContext) {
        MuleEventExprBuilder muleEventExprBuilder = new MuleEventExprBuilder();
        transformComponentModel.getParameter(SET_PAYLOAD).getValue().applyRight(setPayload -> this.findExpression((ComponentAst)setPayload, transformParserContext).ifPresent(expression -> muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(new SimpleExprBuilder((String)expression))))));
        transformComponentModel.getParameter(SET_ATTRIBUTES).getValue().applyRight(setAttributes -> this.findExpression((ComponentAst)setAttributes, transformParserContext).ifPresent(expression -> muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(new SimpleExprBuilder((String)expression))))));
        transformComponentModel.getParameter(VARIABLES).getValue().applyRight(variables -> this.parseVariables((List)variables, muleEventExprBuilder, transformParserContext));
        return muleEventExprBuilder;
    }

    public MuleEventExprBuilder parse(ComponentAst transformComponentModel, Function<String, Optional<URI>> resourceResolver, AstNotification astNotification, AstNodeLocation astNodeLocation) {
        return this.parse(transformComponentModel, new TransformParserContext(resourceResolver, astNotification, astNodeLocation));
    }

    public MuleEventExprBuilder parse(ComponentAst transformComponentModel) {
        return this.parse(transformComponentModel, null, null, null);
    }

    private static class TransformParserContext {
        private final Function<String, Optional<URI>> resourceResolver;
        private final AstNotification astNotification;
        private final AstNodeLocation astNodeLocation;

        public TransformParserContext(Function<String, Optional<URI>> resourceResolver, AstNotification astNotification, AstNodeLocation astNodeLocation) {
            this.resourceResolver = resourceResolver;
            this.astNotification = astNotification;
            this.astNodeLocation = astNodeLocation;
        }

        public Optional<Function<String, Optional<URI>>> getResourceResolver() {
            return Optional.ofNullable(this.resourceResolver);
        }

        public Optional<AstNotification> getAstNotification() {
            return Optional.ofNullable(this.astNotification);
        }

        public Optional<AstNodeLocation> getAstNodeLocation() {
            return Optional.ofNullable(this.astNodeLocation);
        }
    }
}

