package org.mule.datasense.impl.model.ast;

import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.util.Preconditions;

public class AstNodeLocation {

  private final ComponentLocation componentLocation;

  public AstNodeLocation(ComponentLocation componentLocation) {
    Preconditions.checkNotNull(componentLocation, "Invalid null component location.");
    this.componentLocation = componentLocation;
  }

  public ComponentLocation getComponentLocation() {
    return componentLocation;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    AstNodeLocation that = (AstNodeLocation) o;

    return componentLocation.equals(that.componentLocation);

  }

  @Override
  public int hashCode() {
    return componentLocation.hashCode();
  }

  @Override
  public String toString() {
    return String.format("[%s:%s]:%s", componentLocation.getFileName().orElse("unknown"),
                         componentLocation.getLine().orElse(-1), componentLocation.getLocation());
  }
}
