/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.extension;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class ExtensionUtils {
    public static final String PARAMETER_TARGET = "target";
    public static final String PARAMETER_TARGET_VALUE = "targetValue";
    public static final String PARAMETER_OUTPUT_MIME_TYPE = "outputMimeType";
    public static final String PARAMETER_MIME_TYPE = "mimeType";
    private static List<String> RESERVED_PARAMETERS = Arrays.asList("target", "targetValue");

    public static boolean isOutputParameter(String parameter) {
        return RESERVED_PARAMETERS.contains(parameter);
    }

    public static Either<String, String> findParameter(ComponentAst componentModel, String groupName, String parameter) {
        ComponentParameterAst param = componentModel.getParameter(groupName, parameter);
        if (param != null) {
            return param.getValue();
        }
        return Either.right(null);
    }

    public static Optional<String> findTarget(ComponentAst componentModel) {
        return Optional.ofNullable(ExtensionUtils.findParameter(componentModel, "Output", PARAMETER_TARGET).getRight());
    }

    public static Optional<String> findOutputMimeType(ComponentAst componentModel) {
        return Optional.ofNullable(ExtensionUtils.findParameter(componentModel, "General", PARAMETER_OUTPUT_MIME_TYPE).getRight());
    }

    public static Optional<String> findMimeType(ComponentAst componentModel) {
        return Optional.ofNullable(ExtensionUtils.findParameter(componentModel, "General", PARAMETER_MIME_TYPE).getRight());
    }

    public static Optional<String> findTargetValue(ComponentAst componentModel) {
        return Optional.ofNullable(ExtensionUtils.findParameter(componentModel, "Output", PARAMETER_TARGET_VALUE).getLeft());
    }
}

