/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import com.google.common.base.Throwables;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.loader.xml.TypesCatalogXmlLoader;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.common.loader.xml.XmlUtils;
import org.mule.datasense.common.util.Notifier;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.loader.xml.ExtensionOperationTypeDeclarationXmlLoader;
import org.mule.datasense.declarations.loader.xml.MessageProcessorTypeDeclarationXmlLoader;
import org.mule.datasense.declarations.loader.xml.TypeDeclarationXmlLoader;
import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoaderContext;
import org.mule.datasense.enrichment.loader.xml.ComponentModelEnrichmentXmlLoader;
import org.mule.datasense.enrichment.model.ComponentModelEnrichments;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.module.soapkit.metadata.api.Metadata;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.ast.api.ComponentAst;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DataSenseProviderResolver {
    private static final List<ComponentIdentifier> componentIdentifierBlockList = Collections.emptyList();
    private final DataSenseProvider dataSenseProvider;
    private final ApplicationModelResolver applicationModelResolver;
    private final AstNotification astNotification;
    private final Notifier notifier;
    private final TypesCatalog typesCatalog;
    private final ComponentModelEnrichments componentModelEnrichments;
    private final MessageProcessorTypeDeclarationXmlLoader messageProcessorTypeDeclarationXmlLoader;
    private final ExtensionOperationTypeDeclarationXmlLoader extensionOperationTypeDeclarationXmlLoader;
    private final GlobalBindingMetadataTypes globalBindingMetadataTypes;
    private Metadata apiKitMetadata = null;
    private org.mule.module.soapkit.metadata.api.Metadata soapKitMetadata = null;

    public static boolean isDynamicDataSenseSupportedFor(MessageProcessorNode messageProcessorNode) {
        return !componentIdentifierBlockList.contains(messageProcessorNode.getComponentIdentifier());
    }

    public DataSenseProviderResolver(DataSenseProvider dataSenseProvider, ApplicationModelResolver applicationModelResolver, final AstNotification astNotification) {
        this.dataSenseProvider = dataSenseProvider;
        this.applicationModelResolver = applicationModelResolver;
        this.astNotification = astNotification;
        this.notifier = new Notifier(){

            public void reportWarning(ComponentLocation componentLocation, I18nMessage i18nMessage) {
                astNotification.reportWarning(new AstNodeLocation(componentLocation), i18nMessage);
            }

            public void reportWarning(I18nMessage i18nMessage) {
                astNotification.reportWarning(i18nMessage);
            }

            public void reportError(ComponentLocation componentLocation, I18nMessage i18nMessage) {
                astNotification.reportError(new AstNodeLocation(componentLocation), i18nMessage);
            }

            public void reportError(I18nMessage i18nMessage) {
                astNotification.reportError(i18nMessage);
            }

            public void reportFatalError(ComponentLocation componentLocation, I18nMessage i18nMessage) {
                astNotification.reportFatalError(new AstNodeLocation(componentLocation), i18nMessage);
            }

            public void reportFatalError(I18nMessage i18nMessage) {
                astNotification.reportFatalError(i18nMessage);
            }
        };
        ApplicationModel applicationModel = applicationModelResolver.getApplicationModel();
        List<String> typesDataList = applicationModel.findTypesDataList();
        this.typesCatalog = this.loadTypesCatalog(applicationModel, typesDataList);
        this.componentModelEnrichments = this.loadComponentModelEnrichments(typesDataList);
        this.messageProcessorTypeDeclarationXmlLoader = new MessageProcessorTypeDeclarationXmlLoader();
        this.extensionOperationTypeDeclarationXmlLoader = new ExtensionOperationTypeDeclarationXmlLoader();
        try {
            this.buildApiKitMetadata(dataSenseProvider, astNotification, applicationModel);
        }
        catch (Exception e) {
            astNotification.reportError(null, NotificationMessages.MSG_RAML_RESOLUTION_INITIALIZATION(e.getMessage()));
        }
        try {
            this.buildSoapKitMetadata(astNotification, applicationModel);
        }
        catch (Exception e) {
            astNotification.reportError(null, NotificationMessages.MSG_SOAPKIT_RESOLUTION_INITIALIZATION(e.getMessage()));
        }
        this.globalBindingMetadataTypes = new GlobalBindingMetadataTypes(this.getExpressionLanguageMetadataService());
    }

    private ComponentModelEnrichments loadComponentModelEnrichments(List<String> typesDataList) {
        ComponentModelEnrichments componentModelEnrichments = new ComponentModelEnrichments();
        ComponentModelEnrichmentXmlLoader componentModelEnrichmentXmlLoader = new ComponentModelEnrichmentXmlLoader();
        typesDataList.forEach(typesData -> this.loadComponentModelEnrichments(componentModelEnrichments, (String)typesData, componentModelEnrichmentXmlLoader));
        return componentModelEnrichments;
    }

    private void loadComponentModelEnrichments(ComponentModelEnrichments componentModelEnrichments, String typesData, ComponentModelEnrichmentXmlLoader componentModelEnrichmentXmlLoader) {
        try {
            Element element = XmlUtils.parseRootElement((InputSource)new InputSource(new StringReader(typesData)), (boolean)true, (boolean)false);
            componentModelEnrichmentXmlLoader.load(componentModelEnrichments, element, new ComponentModelEnrichmentLoaderContext());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private TypesCatalog loadTypesCatalog(ApplicationModel applicationModel, List<String> typesDataList) {
        try {
            TypesCatalogBuilderContext typesCatalogBuilderContext = new TypesCatalogBuilderContext(this.notifier, this.dataSenseProvider.getExpressionLanguageMetadataService());
            return new TypesCatalogXmlLoader().loadData(typesDataList, typesCatalogBuilderContext, (URI)applicationModel.findResource("").orElse(null));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void buildApiKitMetadata(DataSenseProvider dataSenseProvider, final AstNotification astNotification, ApplicationModel applicationModel) {
        MetadataBuilder apiKitMetadataBuilder = dataSenseProvider.getApikitMetadataBuilder();
        apiKitMetadataBuilder.withApplicationModel(applicationModel.getMuleApplicationModel());
        apiKitMetadataBuilder.withResourceLoader(resource -> {
            if (!resource.startsWith("resource::")) {
                try {
                    new URI(resource);
                }
                catch (URISyntaxException e) {
                    try {
                        resource = new URI(null, null, resource, null).getRawPath();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                try {
                    resource = new URI("api/").resolve(resource).getRawPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return applicationModel.findResource(resource).orElse(null);
        });
        apiKitMetadataBuilder.withNotifier(new org.mule.runtime.apikit.metadata.api.Notifier(){

            public void error(String s) {
                astNotification.reportError(NotificationMessages.MSG_RAML_RESOLUTION_NOTIFICATION("error", s));
            }

            public void warn(String s) {
                astNotification.reportWarning(NotificationMessages.MSG_RAML_RESOLUTION_NOTIFICATION("warning", s));
            }

            public void info(String s) {
                astNotification.reportInfo(NotificationMessages.MSG_RAML_RESOLUTION_NOTIFICATION("info", s));
            }

            public void debug(String s) {
                astNotification.reportDebug(NotificationMessages.MSG_RAML_RESOLUTION_NOTIFICATION("trace", s));
            }
        });
        this.apiKitMetadata = apiKitMetadataBuilder.build();
    }

    private void buildSoapKitMetadata(final AstNotification astNotification, ApplicationModel applicationModel) {
        Metadata.Builder soapKitMetadataBuilder = new Metadata.Builder();
        soapKitMetadataBuilder.withApplicationModel(applicationModel.getMuleApplicationModel());
        soapKitMetadataBuilder.withResourceLoader(resource -> {
            try {
                resource = new URI("api/").resolve(resource).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return applicationModel.findResource(resource).map(uri -> {
                try {
                    return uri.toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }).orElse(null);
        });
        soapKitMetadataBuilder.withNotifier(new org.mule.module.soapkit.metadata.api.Notifier(){

            public void error(String s) {
                astNotification.reportError(NotificationMessages.MSG_SOAPKIT_RESOLUTION_NOTIFICATION("error", s));
            }

            public void warn(String s) {
                astNotification.reportWarning(NotificationMessages.MSG_SOAPKIT_RESOLUTION_NOTIFICATION("warning", s));
            }

            public void info(String s) {
                astNotification.reportInfo(NotificationMessages.MSG_SOAPKIT_RESOLUTION_NOTIFICATION("info", s));
            }

            public void debug(String s) {
                astNotification.reportDebug(NotificationMessages.MSG_SOAPKIT_RESOLUTION_NOTIFICATION("trace", s));
            }
        });
        this.soapKitMetadata = soapKitMetadataBuilder.build();
    }

    public DataSenseProvider getDataSenseProvider() {
        return this.dataSenseProvider;
    }

    public ApplicationModelResolver getApplicationModelResolver() {
        return this.applicationModelResolver;
    }

    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.dataSenseProvider.getExpressionLanguageMetadataService();
    }

    public Optional<TypesCatalog> getTypesCatalog() {
        return Optional.ofNullable(this.typesCatalog);
    }

    public Optional<ComponentModelEnrichments> getComponentModelEnrichments() {
        return Optional.ofNullable(this.componentModelEnrichments);
    }

    public Optional<SourceModel> resolveSourceModel(ComponentAst componentModel) {
        return componentModel.getModel(SourceModel.class);
    }

    public Optional<OperationModel> resolveOperationModel(ComponentAst componentModel) {
        return componentModel.getModel(OperationModel.class);
    }

    private <T> Optional<T> findTypeDeclaration(ComponentAst componentModel, TypeDeclarationXmlLoader<T, Element> typeDeclarationLoader) {
        return this.getComponentModelEnrichments().flatMap(componentModelEnrichments1 -> componentModelEnrichments1.enrich(componentModel).map(o -> (Element)o).map(element -> typeDeclarationLoader.load(element, new TypeDeclarationLoaderContext(componentModel, this.typesCatalog, this.notifier))).filter(Optional::isPresent).map(Optional::get).findFirst());
    }

    public Optional<MessageProcessorTypeDeclaration> findMessageProcessorTypeDeclaration(ComponentAst componentModel) {
        return this.findTypeDeclaration(componentModel, (TypeDeclarationXmlLoader)this.messageProcessorTypeDeclarationXmlLoader);
    }

    public Optional<ExtensionOperationTypeDeclaration> findExtensionOperationTypeDeclaration(ComponentAst componentModel) {
        return this.findTypeDeclaration(componentModel, (TypeDeclarationXmlLoader)this.extensionOperationTypeDeclarationXmlLoader);
    }

    public AstNotification getAstNotification() {
        return this.astNotification;
    }

    public Optional<Metadata> getApiKitMetadata() {
        return Optional.ofNullable(this.apiKitMetadata);
    }

    public Optional<org.mule.module.soapkit.metadata.api.Metadata> getSoapKitMetadata() {
        return Optional.ofNullable(this.soapKitMetadata);
    }

    public Function<String, Optional<URI>> getResourceResolver() {
        return resource -> this.getApplicationModelResolver().getApplicationModel().findResource((String)resource);
    }

    public GlobalBindingMetadataTypes getGlobalBindingMetadataTypes() {
        return this.globalBindingMetadataTypes;
    }
}

