package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitor;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;

import java.util.Optional;

public interface TypeResolver {

  Optional<ComponentModelType> getComponentModelType();

  EventType resolveTypes(MessageProcessorNode messageProcessorNode, TypingMuleAstVisitor typingMuleAstVisitor,
                         TypingMuleAstVisitorContext visitorContext);

  EventType generateIncoming(MessageProcessorNode messageProcessorNode, IncomingAstVisitor incomingAstVisitor,
                             IncomingAstVisitorContext visitorContext);

  EventType generateExpected(MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor,
                             ExpectedAstVisitorContext visitorContext);

  Optional<MuleAstParseProvider> getParseProvider();
}
