/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class ErrorHandlingContext {
    private final String id;
    private final EventType argumentEventType;
    private final Set<ErrorModel> unhandledErrors;
    private boolean open;

    public ErrorHandlingContext(String id, EventType argumentEventType) {
        this.id = id;
        this.argumentEventType = argumentEventType;
        this.unhandledErrors = new LinkedHashSet<ErrorModel>();
        this.open = true;
    }

    public ErrorHandlingContext(String id) {
        this(id, null);
    }

    public Set<ErrorModel> getUnhandledErrors() {
        return this.unhandledErrors;
    }

    public void union(Set<ErrorModel> errorModels) {
        this.unhandledErrors.addAll(errorModels);
    }

    public void handle(ErrorMatcher errorMatcher) {
        this.unhandledErrors.removeIf(errorMatcher::matches);
    }

    public void close() {
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Optional<EventType> getArgumentEventType() {
        return Optional.ofNullable(this.argumentEventType);
    }
}

