/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.PipedChainTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ComponentAst;

public class ForEachTypeResolver
extends PipedChainTypeResolver {
    private static final String ATTR_BATCH_SIZE = "batchSize";
    private static final String ATTR_COLLECTION = "collection";
    private static final String PARAMETER_COLLECTION = "collection";
    private static final String ATTR_COUNTER_VARIABLE_NAME = "counterVariableName";
    private static final String ATTR_MESSAGE_VARIABLE_NAME = "rootMessageVariableName";
    private static final String DEFAULT_COUNTER_VARIABLE_NAME = "counter";
    private static final String DEFAULT_MESSAGE_VARIABLE_NAME = "rootMessage";
    private static final String DEFAULT_COLLECTION_EXPRESSION = "payload";
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final ComponentIdentifier PARAMETER_COLLECTION_IDENTIFIER = ComponentIdentifierUtils.createFromNamespaceAndName("mule", "http://www.mulesoft.org/schema/mule/core", "collection");

    protected static boolean isBatchMode(ComponentAst componentModel) {
        if (componentModel.getModel(ConstructModel.class).map(cm -> cm.getName().equals("foreach")).orElse(false).booleanValue()) {
            Integer batchSize = (Integer)componentModel.getParameter("General", ATTR_BATCH_SIZE).getValue().getRight();
            return batchSize != null && batchSize > 1;
        }
        return false;
    }

    public static Optional<MetadataType> buildInnerPayloadType(MetadataType metadataType) {
        if ((metadataType = TypeUtils.removeNullsFromUnionMetadataType(metadataType)) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)metadataType;
            return Optional.of(arrayType.getType());
        }
        if (metadataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)metadataType;
            LinkedHashSet metadataTypes = new LinkedHashSet();
            objectType.getFields().forEach(objectFieldType -> metadataTypes.add(objectFieldType.getValue()));
            if (metadataTypes.size() == 0) {
                return Optional.empty();
            }
            if (metadataTypes.size() == 1) {
                return Optional.of((MetadataType)metadataTypes.iterator().next());
            }
            UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
            metadataTypes.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
            return Optional.of(unionTypeBuilder.build());
        }
        return Optional.empty();
    }

    protected static Either<String, Object> getCollectionExpression(MessageProcessorNode messageProcessorNode) {
        if (messageProcessorNode == null) {
            return Either.empty();
        }
        return messageProcessorNode.getComponentModel().getParameter("General", "collection").getValue();
    }

    protected static EventType buildInnerEventType(final MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitorContext typingMuleAstVisitorContext, String defaultCounterVariableName) {
        ComponentAst componentModel = messageProcessorNode.getComponentModel();
        boolean batchMode = ForEachTypeResolver.isBatchMode(componentModel);
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        Optional<MessageMetadataType> messageMetadataType = TypeUtils.getMessageMetadataType(inputEventType);
        final AstNotification astNotification = typingMuleAstVisitorContext.getAstNotification();
        MetadataType sourceCollectionMetadataType = ForEachTypeResolver.getCollectionExpression(messageProcessorNode).mapLeft(collectionExpression -> ExpressionLanguageUtils.resolveExpressionType(collectionExpression, inputEventType, typingMuleAstVisitorContext.getTypeBindings(), typingMuleAstVisitorContext.getExpressionLanguageMetadataService(), new ExpressionLanguageMetadataService.MessageCallback((String)collectionExpression){
            final /* synthetic */ String val$collectionExpression;
            {
                this.val$collectionExpression = string;
            }

            public void warning(String message, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
                astNotification.reportWarning(messageProcessorNode.getAstNodeLocation(), NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING(this.val$collectionExpression, message));
            }

            public void error(String message, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
                astNotification.reportError(messageProcessorNode.getAstNodeLocation(), NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR(this.val$collectionExpression, message));
            }
        })).getValue().orElse(null);
        MetadataType elementMetadataType = ForEachTypeResolver.buildInnerPayloadType(sourceCollectionMetadataType).orElse((MetadataType)TypesHelper.getTypeBuilder().anyType().build());
        if (batchMode) {
            muleEventMetadataTypeBuilder.message().payload().arrayType().of(elementMetadataType);
            muleEventMetadataTypeBuilder.message().attributes((MetadataType)TypesHelper.getTypeBuilder().voidType().build());
        } else {
            Optional<MessageMetadataType> optionalElementMessageMetadataType = TypeUtils.asMessageMetadataType(elementMetadataType);
            if (optionalElementMessageMetadataType.isPresent()) {
                MessageMetadataType elementMessageMetadataType = optionalElementMessageMetadataType.get();
                elementMessageMetadataType.getPayloadType().ifPresent(metadataType -> muleEventMetadataTypeBuilder.message().payload(metadataType));
                muleEventMetadataTypeBuilder.message().attributes((MetadataType)elementMessageMetadataType.getAttributesType().orElse(TypesHelper.getTypeBuilder().voidType().build()));
            } else {
                muleEventMetadataTypeBuilder.message().payload(elementMetadataType);
                muleEventMetadataTypeBuilder.message().attributes((MetadataType)TypesHelper.getTypeBuilder().voidType().build());
            }
        }
        if (componentModel.getModel(ConstructModel.class).map(cm -> cm.getName().equals("foreach")).orElse(false).booleanValue()) {
            componentModel.getParameter("General", ATTR_COUNTER_VARIABLE_NAME).getValue().applyRight(counterVariableName -> muleEventMetadataTypeBuilder.addVariable((String)counterVariableName).numberType());
            componentModel.getParameter("General", ATTR_MESSAGE_VARIABLE_NAME).getValue().applyRight(messageVariableName -> muleEventMetadataTypeBuilder.addVariable((String)messageVariableName, (MetadataType)messageMetadataType.orElse(TypesHelper.getMessageMetadataTypeBuilder().build())));
        } else {
            muleEventMetadataTypeBuilder.addVariable(defaultCounterVariableName).numberType();
            muleEventMetadataTypeBuilder.addVariable(DEFAULT_MESSAGE_VARIABLE_NAME, (MetadataType)messageMetadataType.orElse(TypesHelper.getMessageMetadataTypeBuilder().build()));
        }
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    private static String getDefaultMessageVariableName() {
        return DEFAULT_MESSAGE_VARIABLE_NAME;
    }

    private static String getDefaultCounterVariableName() {
        return DEFAULT_COUNTER_VARIABLE_NAME;
    }

    private EventType buildExpectedEventType(MessageProcessorNode messageProcessorNode, EventType innerEventType) {
        ComponentAst componentModel = messageProcessorNode.getComponentModel();
        boolean batchMode = ForEachTypeResolver.isBatchMode(componentModel);
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        ForEachTypeResolver.getCollectionExpression(messageProcessorNode).applyLeft(collectionExpression -> {
            if (collectionExpression.equals(DEFAULT_COLLECTION_EXPRESSION)) {
                MetadataType payloadMetadataType = TypeUtils.getMessageMetadataType(innerEventType).flatMap(MessageMetadataType::getPayloadType).orElse(null);
                if (payloadMetadataType != null) {
                    if (batchMode) {
                        muleEventMetadataTypeBuilder.message().payload(payloadMetadataType);
                    } else {
                        muleEventMetadataTypeBuilder.message().payload((MetadataType)TypesHelper.getTypeBuilder().arrayType().of(payloadMetadataType).build());
                    }
                } else {
                    muleEventMetadataTypeBuilder.message().payload().arrayType().of().anyType();
                }
            }
        });
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        EventType innerEventType = inputEventType;
        List messageProcessorNodes = messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toList());
        Optional<EventType> previousEventType = Optional.empty();
        for (MessageProcessorNode pipedMessageProcessorNode : messageProcessorNodes) {
            EventType pipedInputEvent = previousEventType.isPresent() ? previousEventType.map(eventType -> eventType).orElse(new EventType()) : innerEventType;
            EventType eventType2 = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, pipedInputEvent, typingMuleAstVisitorContext);
            previousEventType = Optional.of(eventType2);
        }
        return this.resolveOutputEventType(messageProcessorNode, inputEventType, previousEventType.orElse(null), typingMuleAstVisitor, typingMuleAstVisitorContext);
    }

    protected EventType resolveOutputEventType(MessageProcessorNode messageProcessorNode, EventType inputEventType, EventType innerEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        EventType outputEventType = inputEventType;
        messageProcessorNode.annotate(new DefinesTypeAnnotation(new EventType()));
        return outputEventType;
    }

    @Override
    protected EventType resolveExpectedInputEventType(EventType innerEventType, MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
        return this.buildExpectedEventType(messageProcessorNode, innerEventType);
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    public Optional<MuleAstParseProvider> getParseProvider() {
        return Optional.of((componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders, muleAstParserContext) -> this.generateAst(componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders));
    }

    private Optional<AstNodeBuilder> generateAst(ComponentIdentifier componentIdentifier, ComponentAst componentModel, ComponentModelType componentModelType, List<MessageProcessorNodeBuilder> messageProcessorNodeBuilders) {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        messageProcessorNodeBuilder.componentModelType(componentModelType);
        messageProcessorNodeBuilder.messageProcessor(this.getComponentIdentifierForeachScopeIn(), m -> {
            m.config(componentModel);
            m.synthetic();
        });
        messageProcessorNodeBuilders.forEach(messageProcessorNodeBuilder::messageProcessor);
        return Optional.of(messageProcessorNodeBuilder);
    }

    protected ComponentIdentifier getComponentIdentifierForeachScopeIn() {
        return DefaultDataSense.COMPONENT_IDENTIFIER_FOREACH_SCOPE_IN;
    }

    @Override
    protected boolean isScope() {
        return true;
    }

    public static class ForEachScopeIn
    extends SingleNodeTypeResolver {
        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            EventType scopeEventType = ForEachTypeResolver.buildInnerEventType(messageProcessorNode, inputEventType, visitorContext, this.getDefaultCounterVariableName());
            messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
            messageProcessorNode.annotate(new DefinesTypeAnnotation(scopeEventType));
            return scopeEventType;
        }

        protected String getDefaultCounterVariableName() {
            return ForEachTypeResolver.DEFAULT_COUNTER_VARIABLE_NAME;
        }

        @Override
        public EventType generateExpected(MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
            return visitorContext.getExpectedEventType();
        }

        @Override
        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return true;
        }
    }
}

