/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.Optional;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.datasense.impl.util.Utils;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class ErrorMapping {
    private final ErrorMatcher errorMatcher;
    private final ErrorModel errorModel;

    public ErrorMapping(ErrorMatcher errorMatcher, ErrorModel errorModel) {
        this.errorMatcher = errorMatcher;
        this.errorModel = errorModel;
    }

    private ErrorMatcher getErrorMatcher() {
        return this.errorMatcher;
    }

    public ErrorModel getErrorModel() {
        return this.errorModel;
    }

    public boolean matches(ErrorModel errorModel) {
        return this.getErrorMatcher().matches(errorModel);
    }

    public static Optional<ErrorMapping> create(String sourceType, String targetType) {
        if (Utils.isNullOrEmpty(sourceType) || Utils.isNullOrEmpty(targetType)) {
            return Optional.empty();
        }
        ErrorMatcher errorMatcher = ErrorHandlingUtils.createErrorMatcher(sourceType);
        return ErrorHandlingUtils.createErrorModel(targetType).map(errorModel -> new ErrorMapping(errorMatcher, (ErrorModel)errorModel));
    }
}

