/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.tooling;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;

import java.util.Optional;

/**
 *
 * @param <T>
 */
public interface TypedApplicationQuery<T extends TypedApplicationQueryResult> {

  /**
   *
   * @param muleApplicationNode
   * @param dataSenseProviderResolver
   * @param astNotification
   * @return
     */
  Optional<T> perform(MuleApplicationNode muleApplicationNode, DataSenseProviderResolver dataSenseProviderResolver,
                      AstNotification astNotification);
}
