/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.datasense.api.notifications.DataSenseNotification;
import org.mule.datasense.api.notifications.DataSenseNotificationType;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.util.LocationUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstNotification {
    public static final transient Logger logger = LoggerFactory.getLogger((String)"org.mule.datasense.notifications");
    private final List<AstNotificationEntry> notifications = new LinkedList<AstNotificationEntry>();

    public List<String> getPlainMessages() {
        return this.notifications.stream().map(this::plainMessage).collect(Collectors.toList());
    }

    public List<DataSenseNotification> getDataSenseNotifications() {
        return this.getDataSenseNotifications((DataSenseNotification dataSenseNotification) -> true);
    }

    public List<DataSenseNotification> getDataSenseNotifications(Predicate<DataSenseNotification> dataSenseNotificationPredicate) {
        return this.notifications.stream().filter(dataSenseNotificationPredicate).collect(Collectors.toList());
    }

    public List<DataSenseNotification> getDataSenseNotifications(Location location) {
        return this.getDataSenseNotifications((DataSenseNotification dataSenseNotification) -> location.equals(dataSenseNotification.getComponentLocation().map(componentLocation -> LocationUtils.valueOf(componentLocation.getLocation())).orElse(null)));
    }

    private String plainMessage(AstNotificationEntry astNotificationEntry) {
        return String.format("[%s] %s: Message: %s. %s", astNotificationEntry.getNotificationType(), astNotificationEntry.getAstNodeLocation().map(AstNodeLocation::toString).orElse("unknown"), astNotificationEntry.getMessage().getMessage(), astNotificationEntry.getReason().map(i18nMessage -> " - Reason: " + i18nMessage.getMessage()).orElse(""));
    }

    private void log(AstNotificationEntry astNotificationEntry) {
        logger.debug(this.plainMessage(astNotificationEntry));
    }

    private void report(AstNotificationEntry astNotificationEntry) {
        this.log(astNotificationEntry);
        this.notifications.add(astNotificationEntry);
    }

    public void reportFatalError(I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.FATAL_ERROR, message));
    }

    public void reportFatalError(AstNodeLocation astNodeLocation, I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.FATAL_ERROR, astNodeLocation, message));
    }

    public void reportFatalError(AstNodeLocation astNodeLocation, I18nMessage message, FailureCode failureCode, MetadataComponent metadataComponent, String failingElement, I18nMessage reason) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.FATAL_ERROR, astNodeLocation, message, failureCode, metadataComponent, failingElement, reason));
    }

    public void reportError(AstNodeLocation astNodeLocation, I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.ERROR, astNodeLocation, message));
    }

    public void reportError(I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.ERROR, null, message));
    }

    public void reportError(AstNodeLocation astNodeLocation, I18nMessage message, FailureCode failureCode, MetadataComponent metadataComponent, String failingElement, I18nMessage reason) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.ERROR, astNodeLocation, message, failureCode, metadataComponent, failingElement, reason));
    }

    public void reportWarning(AstNodeLocation astNodeLocation, I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.WARNING, astNodeLocation, message));
    }

    public void reportWarning(I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.WARNING, message));
    }

    public void reportWarning(AstNodeLocation astNodeLocation, I18nMessage message, FailureCode failureCode, MetadataComponent metadataComponent, String failingElement, I18nMessage reason) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.WARNING, astNodeLocation, message, failureCode, metadataComponent, failingElement, reason));
    }

    public void reportInfo(AstNodeLocation astNodeLocation, I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.INFO, astNodeLocation, message));
    }

    public void reportInfo(I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.INFO, message));
    }

    public void reportDebug(I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.DEBUG, message));
    }

    public void reportDebug(AstNodeLocation astNodeLocation, I18nMessage message) {
        this.report(new AstNotificationEntry(DataSenseNotificationType.DEBUG, astNodeLocation, message));
    }

    private boolean hasNotificationWithType(DataSenseNotificationType notificationType) {
        return this.notifications.stream().filter(astNotificationEntry -> ((AstNotificationEntry)astNotificationEntry).notificationType == notificationType).findFirst().isPresent();
    }

    public boolean hasErrors() {
        return this.hasNotificationWithType(DataSenseNotificationType.ERROR);
    }

    public boolean hasWarnings() {
        return this.hasNotificationWithType(DataSenseNotificationType.WARNING);
    }

    public boolean hasFatalErrors() {
        return this.hasNotificationWithType(DataSenseNotificationType.FATAL_ERROR);
    }

    private class AstNotificationEntry
    implements DataSenseNotification {
        private final DataSenseNotificationType notificationType;
        private AstNodeLocation astNodeLocation;
        private I18nMessage message;
        private MetadataComponent metadataComponent;
        private String failingElement;
        private FailureCode failureCode;
        private I18nMessage reason;

        public AstNotificationEntry(DataSenseNotificationType notificationType, AstNodeLocation astNodeLocation, I18nMessage message, FailureCode failureCode, MetadataComponent metadataComponent, String failingElement, I18nMessage reason) {
            Preconditions.checkNotNull((Object)notificationType, (String)"NotificationType not present.");
            Preconditions.checkNotNull((Object)message, (String)"Message not present.");
            this.notificationType = notificationType;
            this.astNodeLocation = astNodeLocation;
            this.message = message;
            this.failureCode = failureCode;
            this.metadataComponent = metadataComponent;
            this.failingElement = failingElement;
            this.reason = reason;
        }

        public AstNotificationEntry(DataSenseNotificationType notificationType, AstNodeLocation astNodeLocation, I18nMessage message) {
            this(notificationType, astNodeLocation, message, null, null, null, null);
        }

        public AstNotificationEntry(DataSenseNotificationType notificationType, I18nMessage message) {
            this(notificationType, null, message);
        }

        public DataSenseNotificationType getNotificationType() {
            return this.notificationType;
        }

        public I18nMessage getMessage() {
            return this.message;
        }

        public Optional<AstNodeLocation> getAstNodeLocation() {
            return Optional.ofNullable(this.astNodeLocation);
        }

        public Optional<ComponentLocation> getComponentLocation() {
            return this.getAstNodeLocation().map(AstNodeLocation::getComponentLocation);
        }

        public Optional<MetadataComponent> getMetadataComponent() {
            return Optional.ofNullable(this.metadataComponent);
        }

        public Optional<String> getFailingElement() {
            return Optional.ofNullable(this.failingElement);
        }

        public Optional<FailureCode> getFailureCode() {
            return Optional.ofNullable(this.failureCode);
        }

        public Optional<I18nMessage> getReason() {
            return Optional.ofNullable(this.reason);
        }

        public String toString() {
            return "AstNotificationEntry{notificationType=" + this.notificationType + ", astNodeLocation=" + this.astNodeLocation + ", message=" + this.message + ", metadataComponent=" + this.metadataComponent + ", failingElement='" + this.failingElement + '\'' + ", failureCode=" + this.failureCode + ", reason=" + this.reason + '}';
        }
    }
}

