/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.BaseAstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleApplicationNode
extends BaseAstNode {
    private final List<MuleFlowNode> muleFlowNodes = new ArrayList<MuleFlowNode>();
    private final Map<String, MuleFlowNode> muleFlowNodeByNameMap = new HashMap<String, MuleFlowNode>();
    private final Map<ComponentLocation, MessageProcessorNode> messageProcessorNodeMap = new HashMap<ComponentLocation, MessageProcessorNode>();
    private final Map<String, ComponentLocation> componentLocationByNameMap = new HashMap<String, ComponentLocation>();
    private final Map<String, ComponentLocation> componentLocationByLocationMap = new HashMap<String, ComponentLocation>();

    public MuleApplicationNode(ComponentIdentifier componentIdentifier, Stream<MuleFlowNode> muleFlowNodes) {
        super(componentIdentifier);
        muleFlowNodes.forEach(this::add);
    }

    private void add(MuleFlowNode muleFlowNode) {
        this.muleFlowNodes.add(muleFlowNode);
        this.muleFlowNodeByNameMap.put(muleFlowNode.getName(), muleFlowNode);
    }

    public Stream<MuleFlowNode> getMuleFlowNodes() {
        return this.muleFlowNodes.stream();
    }

    @Override
    public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
        return astNodeVisitor.visit(this, context);
    }

    public void register(ComponentLocation componentLocation, MessageProcessorNode messageProcessorNode) {
        Preconditions.checkState((!this.messageProcessorNodeMap.containsKey(componentLocation) ? 1 : 0) != 0, (Object)String.format("Node already registered for componentLocation %s", componentLocation));
        this.messageProcessorNodeMap.put(componentLocation, messageProcessorNode);
        this.componentLocationByLocationMap.put(componentLocation.getLocation(), componentLocation);
        Optional.ofNullable(messageProcessorNode.getComponentModel()).flatMap(ComponentAst::getComponentId).ifPresent(name -> this.componentLocationByNameMap.put((String)name, componentLocation));
    }

    private Optional<MessageProcessorNode> findMessageProcessorNode(ComponentLocation componentLocation) {
        if (componentLocation == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.messageProcessorNodeMap.get(componentLocation));
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(String location) {
        if (location == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.componentLocationByLocationMap.get(location)).flatMap(this::findMessageProcessorNode);
    }

    public Optional<ComponentLocation> findComponentLocationByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.componentLocationByNameMap.get(name));
    }

    public Optional<MessageProcessorNode> findMessageProcessorNodeByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return this.findComponentLocationByName(name).flatMap(this::findMessageProcessorNode);
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(Location location) {
        return this.findMessageProcessorNode(location.toString());
    }

    public Optional<MuleFlowNode> findMuleFlowNode(String flow) {
        if (flow == null) {
            return Optional.empty();
        }
        return this.getMuleFlowNodes().filter(muleFlowNode -> flow.equals(muleFlowNode.getName())).findFirst();
    }

    public Stream<MessageProcessorNode> findMessageProcessorNodes(boolean includeRoot) {
        return this.messageProcessorNodeMap.values().stream().filter(messageProcessorNode -> includeRoot || !messageProcessorNode.isRootMessageProcessorNode());
    }

    public Stream<MessageProcessorNode> findMessageProcessorNodes() {
        return this.findMessageProcessorNodes(false);
    }
}

