/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ProcessorChainTypeResolver;
import org.mule.metadata.api.model.MetadataType;

public class ErrorHandlerTypeResolver
extends ProcessorChainTypeResolver {
    @Override
    protected boolean definesErrorHandlingContext() {
        return false;
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        typingMuleAstVisitorContext.getErrorHandlingEnvironment().enterErrorHandling();
        VarDecl errorVarDecl = inputEventType.get("#error#").orElse(new VarDecl("#error#", (MetadataType)TypesHelper.getTypeBuilder().voidType().build()));
        EventType resolve = super.resolve(messageProcessorNode, inputEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
        return TypeUtils.merge(resolve, new EventType(Stream.of(errorVarDecl)));
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    protected boolean isScope() {
        return false;
    }

    @Override
    protected boolean isSequential() {
        return false;
    }
}

