/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.operation.InputMapping;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class OperationCall {
    private String name;
    private final List<InputMapping> inputMappingList;
    private Map<String, InputMapping> inputMappingMap;
    private final Set<ErrorModel> errorModelSet;
    private final MetadataType returnType;
    private final String target;
    private final String targetValueExpression;
    private final String outputMimeType;

    public OperationCall(String name, Stream<InputMapping> inputMappings, Set<ErrorModel> errorModelSet, MetadataType returnType, String target, String targetValueExpression, String outputMimeType) {
        this.name = name;
        this.inputMappingList = inputMappings.collect(Collectors.toList());
        this.errorModelSet = errorModelSet;
        this.returnType = returnType;
        this.target = target;
        this.targetValueExpression = targetValueExpression;
        this.outputMimeType = outputMimeType;
        this.inputMappingMap = new HashMap<String, InputMapping>();
        this.inputMappingList.forEach(inputMapping -> this.inputMappingMap.put(inputMapping.getInputParameter().getName(), (InputMapping)inputMapping));
    }

    public String getName() {
        return this.name;
    }

    public Stream<InputMapping> getInputMappings() {
        return this.inputMappingList.stream();
    }

    public Optional<InputMapping> getInputMapping(String parameterName) {
        return Optional.ofNullable(this.inputMappingMap.get(parameterName));
    }

    public MetadataType getReturnType() {
        return this.returnType;
    }

    public Optional<String> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public String getTargetValueExpression() {
        return this.targetValueExpression;
    }

    public String getOutputMimeType() {
        return this.outputMimeType;
    }

    public Set<ErrorModel> getErrorModels() {
        return this.errorModelSet;
    }
}

