package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

public class DynamicOperationAnnotator extends BaseDynamicAnnotator<OperationModel> {

  protected MetadataResult<OperationModel> resolveMetadata(MessageProcessorNode messageProcessorNode,
                                                           DataSenseMetadataProvider dataSenseMetadataProvider,
                                                           ComponentLocationAnnotation componentLocationAnnotation,
                                                           AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    final MetadataResult<OperationModel> operationMetadata =
        dataSenseMetadataProvider.getOperationMetadata(messageProcessorNode.getComponentModel());
    if (operationMetadata != null) {
      if (operationMetadata.isSuccess()) {
        final OperationModel operationModel = operationMetadata.get();
        messageProcessorNode.annotate(new OperationModelAnnotation(operationModel));
      }
    } else {
      annotatingMuleAstVisitorContext.getAstNotification()
          .reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory
              .createStaticMessage(NotificationMessages.MSG_FAILED_TO_OBTAIN_METADATA,
                                   "operation metadata for component_path: " + componentLocationAnnotation.getLocation()));
    }
    return operationMetadata;

  }
}
