/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.tooling;

import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

// incoming upstream / expected downstream mule event types
public class TypeContextQueryResult implements TypedApplicationQueryResult {

  private final MetadataType incoming;
  private final MetadataType expected;
  private final MetadataType result;
  private final MetadataType expectedInput;

  public TypeContextQueryResult(MetadataType incoming, MetadataType expected, MetadataType result, MetadataType expectedInput) {
    this.incoming = incoming;
    this.expected = expected;
    this.result = result;
    this.expectedInput = expectedInput;
  }

  public Optional<MetadataType> getIncoming() {
    return Optional.ofNullable(incoming);
  }

  public Optional<MetadataType> getExpected() {
    return Optional.ofNullable(expected);
  }

  public Optional<MetadataType> getResult() {
    return Optional.ofNullable(result);
  }

  public Optional<MetadataType> getActualInput() {
    return getIncoming();
  }

  public Optional<MetadataType> getActualOutput() {
    return getResult();
  }

  public Optional<MetadataType> getExpectedInput() {
    return Optional.ofNullable(expectedInput);
  }

  public Optional<MetadataType> getExpectedOutput() {
    return getExpected();
  }

}
