package org.mule.datasense.impl.model.types;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.Map;
import java.util.Optional;

public class MetadataTypeSubstitution extends MetadataTypeTransform {

  private final Map<String, MetadataType> substitutions;

  public MetadataTypeSubstitution(Map<String, MetadataType> substitutions) {
    this.substitutions = substitutions;
  }

  public Optional<Map<String, MetadataType>> getSubstitutions() {
    return Optional.ofNullable(substitutions);
  }

  @Override
  protected MetadataType transformDefaultTypeParameterType(String name, MetadataFormat metadataFormat,
                                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return getSubstitutions().map(substitutions -> substitutions.get(name))
        .orElse(super.transformDefaultTypeParameterType(name, metadataFormat, extensions));
  }

}
