/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.types.VarDecl;

public class EventType {
    private List<VarDecl> varDecls;
    private Map<String, VarDecl> varDeclarationsByName;

    public EventType(Stream<VarDecl> varDeclarations) {
        Preconditions.checkNotNull(varDeclarations);
        this.varDecls = new ArrayList<VarDecl>();
        this.varDeclarationsByName = new HashMap<String, VarDecl>();
        varDeclarations.forEach(this::addVarDeclaration);
    }

    public EventType() {
        this(Collections.emptySet().stream());
    }

    private void addVarDeclaration(VarDecl varDecl) {
        this.varDecls.add(varDecl);
        this.varDeclarationsByName.put(varDecl.getName(), varDecl);
    }

    public Stream<VarDecl> getVarDecls() {
        return this.varDecls.stream();
    }

    public Optional<VarDecl> get(String name) {
        return Optional.ofNullable(this.varDeclarationsByName.get(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventType eventType = (EventType)o;
        return this.varDecls.equals(eventType.varDecls);
    }

    public int hashCode() {
        return this.varDecls.hashCode();
    }

    public String toString() {
        return "EventType{varDeclarations=" + this.varDecls + '}';
    }
}

