package org.mule.datasense.impl.model.annotations.metadata;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.runtime.api.meta.model.source.SourceModel;

public class SourceModelAnnotation implements AstNodeAnnotation {

  private final SourceModel sourceModel;

  public SourceModelAnnotation(SourceModel sourceModel) {
    Preconditions.checkNotNull(sourceModel);
    this.sourceModel = sourceModel;
  }

  public SourceModel getSourceModel() {
    return sourceModel;
  }
}
