/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.model.types;

import com.google.common.base.Preconditions;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

import static java.util.Optional.ofNullable;

/**
 *
 */
public class VarDecl {

  private final String name;
  private final MetadataType metadataType;
  private final VarDeclMetadata varDeclMetadata;
  private final boolean optional;

  public VarDecl(String name, MetadataType metadataType) {
    this(name, metadataType, false, null);
  }

  public VarDecl(String name, MetadataType metadataType, boolean optional) {
    this(name, metadataType, optional, null);
  }

  public VarDecl(String name, MetadataType metadataType, VarDeclMetadata varDeclMetadata) {
    this(name, metadataType, false, varDeclMetadata);
  }

  public VarDecl(String name, MetadataType metadataType, boolean optional, VarDeclMetadata varDeclMetadata) {
    Preconditions.checkNotNull(name);
    Preconditions.checkNotNull(metadataType);
    this.optional = optional;
    this.name = name;
    this.metadataType = metadataType;
    this.varDeclMetadata = varDeclMetadata;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    VarDecl varDecl = (VarDecl) o;

    return name.equals(varDecl.name);

  }

  @Override
  public int hashCode() {
    return name.hashCode();
  }

  public String getName() {
    return name;
  }

  public MetadataType getType() {
    return metadataType;
  }

  public boolean isOptional() {
    return optional;
  }

  public Optional<VarDeclMetadata> getMetadata() {
    return ofNullable(varDeclMetadata);
  }

  @Override
  public String toString() {
    return "VarDecl{" +
        "name='" + name + '\'' +
        ", metadataType=" + TypesHelper.toString(metadataType) +
        '}';
  }
}
