package org.mule.datasense.impl.phases.builder;

import org.mule.datasenseapi.api.ConfigResolutionScope;
import org.mule.runtime.ast.api.ComponentAst;

public class ConfigResolutionScopeStrategy implements DataSenseResolutionScopeStrategy {

  private final ConfigResolutionScope dataSenseResolutionScope;

  public ConfigResolutionScopeStrategy(ConfigResolutionScope dataSenseResolutionScope) {
    this.dataSenseResolutionScope = dataSenseResolutionScope;
  }

  @Override
  public boolean match(ComponentAst componentModel) {
    return componentModel.getLocation().getFileName().map(s -> s.equals(dataSenseResolutionScope.getMuleConfig()))
        .orElse(false);
  }
}
