package org.mule.datasense.impl.phases.typing;

import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.BaseAstNodeVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingEnvironment;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class TypingMuleAstVisitorContext extends BaseAstNodeVisitorContext {

  private final TypingEnvironment typingEnvironment;
  private final ErrorHandlingEnvironment errorHandlingEnvironment;

  public TypingMuleAstVisitorContext(TypeResolverRegistry typeResolverRegistry, AstNotification astNotification,
                                     ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    super(typeResolverRegistry, astNotification, expressionLanguageMetadataService);
    this.typingEnvironment = new TypingEnvironment();
    this.errorHandlingEnvironment = new ErrorHandlingEnvironment();
  }

  public TypingEnvironment getTypingEnvironment() {
    return typingEnvironment;
  }

  public ErrorHandlingEnvironment getErrorHandlingEnvironment() {
    return errorHandlingEnvironment;
  }
}
