/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.phases.annotators.BaseExtensionAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ComponentAst;

abstract class BaseDynamicAnnotator<T extends ComponentModel>
extends BaseExtensionAnnotator {
    BaseDynamicAnnotator() {
    }

    private boolean requiresDynamicMetadataResolution(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        Optional maybeHasDynamicMetadataAnnotation = messageProcessorNode.getAnnotation(HasDynamicMetadataAnnotation.class);
        if (!maybeHasDynamicMetadataAnnotation.isPresent()) {
            return false;
        }
        boolean result = true;
        HasDynamicMetadataAnnotation hasDynamicMetadataAnnotation = (HasDynamicMetadataAnnotation)maybeHasDynamicMetadataAnnotation.get();
        Collection<ParameterModel> incompleteParameters = hasDynamicMetadataAnnotation.getIncompleteParameters();
        if (incompleteParameters != null && incompleteParameters.size() > 0) {
            annotatingMuleAstVisitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), NotificationMessages.MSG_DYNAMIC_METADATA_RESOLUTION_SKIPPED_CAUSE_INCOMPLETE_PARAMETERS(incompleteParameters.stream().map(NamedObject::getName).collect(Collectors.toList())));
            result = false;
        }
        return result;
    }

    @Override
    protected Optional<ComponentModel> resolveComponentModel(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext, DataSenseProviderResolver dataSenseProviderResolver, ComponentAst componentModel) {
        Optional<Object> result = Optional.empty();
        boolean requiresDynamicMetadataResolution = this.requiresDynamicMetadataResolution(messageProcessorNode, annotatingMuleAstVisitorContext);
        if (requiresDynamicMetadataResolution) {
            result = dataSenseProviderResolver.getDataSenseProvider().getDataSenseMetadataProvider().flatMap(dataSenseMetadataProvider -> annotatingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class).map(muleFlowAnnotation -> messageProcessorNode.getAnnotation(ComponentLocationAnnotation.class).map(componentPathAnnotation -> {
                ComponentModel metadataComponentModel = null;
                MetadataResult<T> metadataResult = null;
                if (DataSenseProviderResolver.isDynamicDataSenseSupportedFor(messageProcessorNode)) {
                    metadataResult = this.resolveMetadata(messageProcessorNode, (DataSenseMetadataProvider)dataSenseMetadataProvider, (ComponentLocationAnnotation)componentPathAnnotation, annotatingMuleAstVisitorContext);
                }
                if (metadataResult != null) {
                    if (!metadataResult.isSuccess()) {
                        metadataResult.getFailures().forEach(metadataFailure -> annotatingMuleAstVisitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), NotificationMessages.MSG_FAILED_TO_RESOLVE_DYNAMIC_MODEL(metadataFailure), metadataFailure.getFailureCode(), metadataFailure.getFailingComponent(), metadataFailure.getFailingElement().orElse(null), NotificationMessages.REASON_FAILED_TO_RESOLVE_DYNAMIC_MODEL(metadataFailure)));
                    }
                    metadataComponentModel = (ComponentModel)metadataResult.get();
                }
                return metadataComponentModel;
            }))).orElse(Optional.empty());
        }
        return result;
    }

    protected abstract MetadataResult<T> resolveMetadata(MessageProcessorNode var1, DataSenseMetadataProvider var2, ComponentLocationAnnotation var3, AnnotatingMuleAstVisitorContext var4);
}

