/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.phases.builder.DataSenseResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.DependenciesResolutionScopeStrategy;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class SimpleDependenciesResolutionScopeStrategy
extends DependenciesResolutionScopeStrategy {
    private final List<String> included = this.initLocations();

    public SimpleDependenciesResolutionScopeStrategy(ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy) {
        super(applicationModel, dataSenseProvider, dataSenseResolutionScopeStrategy);
    }

    private List<String> initLocations() {
        ArrayList<String> result = new ArrayList<String>();
        ArtifactAst muleApplicationModel = this.getApplicationModel().getMuleApplicationModel();
        ArrayListMultimap flowDependenciesByFlow = ArrayListMultimap.create();
        muleApplicationModel.topLevelComponentsStream().filter(topLevelComp -> topLevelComp.getComponentId().isPresent()).forEach(arg_0 -> SimpleDependenciesResolutionScopeStrategy.lambda$initLocations$12((Multimap)flowDependenciesByFlow, muleApplicationModel, arg_0));
        ArrayDeque deque = new ArrayDeque();
        muleApplicationModel.topLevelComponentsStream().filter(topLevelComp -> this.getDataSenseResolutionScopeStrategy().match((ComponentAst)topLevelComp)).forEach(componentAst -> componentAst.getComponentId().ifPresent(deque::add));
        result.clear();
        while (!deque.isEmpty()) {
            String flow = (String)deque.pop();
            if (result.contains(flow)) continue;
            result.add(flow);
            Collection flowDependencies = flowDependenciesByFlow.get((Object)flow);
            flowDependencies.forEach(deque::offer);
        }
        return result;
    }

    @Override
    public boolean match(ComponentAst componentModel) {
        return super.match(componentModel) || this.visited(componentModel);
    }

    private boolean visited(ComponentAst componentModel) {
        return this.included.contains(componentModel.getComponentId().orElse(null));
    }

    private static /* synthetic */ void lambda$initLocations$12(Multimap flowDependenciesByFlow, ArtifactAst muleApplicationModel, ComponentAst topLevelComp) {
        topLevelComp.recursiveStream().forEach(comp -> topLevelComp.getComponentId().ifPresent(flowName -> {
            MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)MuleStereotypes.FLOW).ifPresent(param -> Optional.ofNullable(param.getRawValue()).ifPresent(flowRefName -> flowDependenciesByFlow.put(flowName, flowRefName)));
            MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)MuleStereotypes.SUB_FLOW).ifPresent(param -> Optional.ofNullable(param.getRawValue()).ifPresent(flowRefName -> flowDependenciesByFlow.put(flowName, flowRefName)));
            MuleAstUtils.parameterOfType((ComponentAst)comp, (StereotypeModel)MuleStereotypes.PROCESSOR).ifPresent(param -> muleApplicationModel.filteredComponents(componentModel -> componentModel.getComponentId().map(name -> param.getRawValue().equals(name)).orElse(false)).forEach(componentModel -> Optional.ofNullable(componentModel.getLocation().getRootContainerName()).ifPresent(flowRefName -> flowDependenciesByFlow.put(flowName, flowRefName))));
        }));
    }
}

