/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import java.util.Optional;
import org.mule.datasense.impl.model.event.DefElemValueExpr;
import org.mule.datasense.impl.model.event.Expr;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class MessageExpr
implements DefElemValueExpr {
    private final Optional<Expr> payload;
    private final Optional<Expr> attributes;

    public MessageExpr(Expr payload, Expr attributes) {
        this.payload = Optional.ofNullable(payload);
        this.attributes = Optional.ofNullable(attributes);
    }

    public MessageMetadataType resolveType(MuleEventMetadataType muleEventMetadataType, ResolveTypeContext resolveTypeContext) {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
        this.payload.ifPresent(expr -> messageMetadataTypeBuilder.payload(expr.resolveType(muleEventMetadataType, resolveTypeContext)));
        this.attributes.ifPresent(expr -> messageMetadataTypeBuilder.attributes(expr.resolveType(muleEventMetadataType, resolveTypeContext)));
        return messageMetadataTypeBuilder.build();
    }

    @Override
    public void resolveInputType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder, MetadataType metadataType, ResolveTypeContext resolveTypeContext) {
        Optional<MessageMetadataType> messageType = Optional.ofNullable(metadataType instanceof MessageMetadataType ? (MessageMetadataType)metadataType : null);
        this.payload.ifPresent(expr -> {
            MetadataType payloadType = (MetadataType)messageType.flatMap(messageMetadataType -> messageMetadataType.getPayloadType()).orElse(TypesHelper.getTypeBuilder().anyType().build());
            expr.resolveInputType(payloadType, muleEventMetadataTypeBuilder, resolveTypeContext);
        });
        this.attributes.ifPresent(expr -> {
            MetadataType attributesType = (MetadataType)messageType.flatMap(messageMetadataType -> messageMetadataType.getAttributesType()).orElse(TypesHelper.getTypeBuilder().anyType().build());
            expr.resolveInputType(attributesType, muleEventMetadataTypeBuilder, resolveTypeContext);
        });
    }
}

