/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.encryption.jce;

import org.mule.encryption.key.EncryptionKeyFactory;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class JCEPbeEncrypter extends JCEEncrypter {

  public JCEPbeEncrypter(String transformation, EncryptionKeyFactory keyFactory) {
    this(transformation, null, keyFactory);
  }

  public JCEPbeEncrypter(String transformation, String provider, EncryptionKeyFactory keyFactory) {
    super(transformation, provider, keyFactory);
  }

  @Override
  protected void initCipher(Cipher cipher, Key cipherKey, int mode)
      throws InvalidKeyException, InvalidAlgorithmParameterException {
    IvParameterSpec ivParam = new IvParameterSpec(Arrays.copyOfRange(cipherKey.getEncoded(), 0, cipher.getBlockSize()));
    cipher.init(mode, cipherKey, new PBEParameterSpec("12345678".getBytes(), 20, ivParam));
  }
}
