/*
 * Decompiled with CFR 0.152.
 */
package org.mule.encryption.jce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.encryption.exception.MuleInvalidAlgorithmConfigurationException;
import org.mule.encryption.exception.MuleInvalidKeyException;
import org.mule.encryption.jce.JCE;
import org.mule.encryption.key.EncryptionKeyFactory;

public class JCEEncrypter
implements Encrypter {
    private static final String INSTALL_JCE_MESSAGE = " You need to install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files";
    private static final String ECB = "ECB";
    private final String provider;
    private final String transformation;
    private final EncryptionKeyFactory keyFactory;
    private final boolean useRandomIV;

    public JCEEncrypter(String transformation, EncryptionKeyFactory keyFactory) {
        this(transformation, null, keyFactory);
    }

    public JCEEncrypter(String transformation, String provider, EncryptionKeyFactory keyFactory) {
        this(transformation, provider, keyFactory, false);
    }

    public JCEEncrypter(String transformation, EncryptionKeyFactory keyFactory, boolean useRandomIV) {
        this(transformation, null, keyFactory, useRandomIV);
    }

    public JCEEncrypter(String transformation, String provider, EncryptionKeyFactory keyFactory, boolean useRandomIV) {
        this.transformation = transformation;
        this.provider = provider;
        this.keyFactory = keyFactory;
        this.useRandomIV = useRandomIV;
    }

    @Override
    public byte[] decrypt(byte[] content) throws MuleEncryptionException {
        return this.runCipher(content, this.keyFactory.decryptionKey(), 2);
    }

    @Override
    public byte[] encrypt(byte[] content) throws MuleEncryptionException {
        return this.runCipher(content, this.keyFactory.encryptionKey(), 1);
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(IvParameterSpec ivParam) {
        return ivParam;
    }

    private byte[] runCipher(byte[] content, Key key, int mode) throws MuleEncryptionException {
        try {
            Cipher cipher = this.getCipher();
            byte[] ivInByteArray = new byte[cipher.getBlockSize()];
            String[] cipherParts = this.transformation.split("/");
            if (cipherParts.length >= 2 && ECB.equals(cipherParts[1])) {
                cipher.init(mode, key);
            } else {
                SecureRandom secureRandom = new SecureRandom();
                if (this.useRandomIV) {
                    if (mode == 1) {
                        secureRandom.nextBytes(ivInByteArray);
                    } else {
                        ivInByteArray = Arrays.copyOfRange(content, 0, cipher.getBlockSize());
                        content = Arrays.copyOfRange(content, cipher.getBlockSize(), content.length);
                    }
                } else {
                    ivInByteArray = Arrays.copyOfRange(key.getEncoded(), 0, cipher.getBlockSize());
                }
                cipher.init(mode, key, this.getAlgorithmParameterSpec(new IvParameterSpec(ivInByteArray)), secureRandom);
            }
            byte[] result = cipher.doFinal(content);
            if (mode == 1 && this.useRandomIV) {
                byte[] byteArrayToConcatEncryptedDataAndIV = new byte[ivInByteArray.length + result.length];
                System.arraycopy(ivInByteArray, 0, byteArrayToConcatEncryptedDataAndIV, 0, ivInByteArray.length);
                System.arraycopy(result, 0, byteArrayToConcatEncryptedDataAndIV, ivInByteArray.length, result.length);
                return byteArrayToConcatEncryptedDataAndIV;
            }
            return result;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw this.invalidAlgorithmConfigurationException(String.format("Wrong configuration for algorithm '%s'", this.transformation), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.invalidAlgorithmConfigurationException(String.format("Cipher '%s' not found", this.transformation), e);
        }
        catch (NoSuchPaddingException e) {
            throw this.invalidAlgorithmConfigurationException(String.format("Invalid padding selected for cipher '%s'", this.transformation), e);
        }
        catch (NoSuchProviderException e) {
            throw this.invalidAlgorithmConfigurationException(String.format("Provider '%s' not found", this.provider), e);
        }
        catch (InvalidKeyException e) {
            throw this.handleInvalidKeyException(e, new String(key.getEncoded()));
        }
        catch (Exception e) {
            throw new MuleEncryptionException("Could not encrypt or decrypt the data.", e);
        }
    }

    private Cipher getCipher() throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.provider == null ? Cipher.getInstance(this.transformation) : Cipher.getInstance(this.transformation, this.provider);
    }

    private MuleEncryptionException invalidAlgorithmConfigurationException(String message, Exception e) {
        if (!JCE.isJCEInstalled()) {
            message = message + INSTALL_JCE_MESSAGE;
        }
        return new MuleInvalidAlgorithmConfigurationException(message, e);
    }

    private MuleEncryptionException handleInvalidKeyException(InvalidKeyException e, String key) {
        String message = String.format("The key is invalid, please make sure it's of a supported size (actual is %s)", key.length());
        return new MuleInvalidKeyException(message, e);
    }
}

